/*
 * *
 *  * @(#)PromotionDto.java 2.0.0 7/9/19 3:01 PM
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request;

import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Transient;
import javax.validation.Valid;

/**
 * 促销活动基本信息
 *
 * @author luo.lei
 * @since 2.0.0
 */
public class PromotionDto {

    @ApiModelProperty(value = "活动基础信息")
    @Valid
    private PromotionBaseInfoDto infoDto;

    @ApiModelProperty(value = "活动基础条件信息")
    @Valid
    private PromotionBaseConditionDto baseConditionDto;

    @Transient
    /**
     * 活动ID ，逻辑处理使用 不需要外部传入
     */
    private long activityId ;


    public long getActivityId() {
        return activityId;
    }

    public void setActivityId(long activityId) {
        this.activityId = activityId;
    }

    public PromotionBaseInfoDto getInfoDto() {
        return infoDto;
    }

    public void setInfoDto(PromotionBaseInfoDto infoDto) {
        this.infoDto = infoDto;
    }

    public PromotionBaseConditionDto getBaseConditionDto() {
        return baseConditionDto;
    }

    public void setBaseConditionDto(PromotionBaseConditionDto baseConditionDto) {
        this.baseConditionDto = baseConditionDto;
    }
}
