package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request;

import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityStatusEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 促销查询dto
 *
 * @author chen.fangliang
 * @date 2019/7/4 15:20
 */
@ApiModel(value = "PromotionQueryReqDto" , description = "促销查询dto")
public class PromotionQueryReqDto extends RequestDto {

    @ApiModelProperty(name = "id", value = "编号")
    private Long id;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(name = "beginTime", value = "开始时间")
    private Date beginTime;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(name = "beginTimeStart", value = "开始时间起点")
    private Date beginTimeStart;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(name = "beginTimeEnd", value = "开始时间终点")
    private Date beginTimeEnd;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(name = "endTime", value = "结束时间")
    private Date endTime;

    @ApiModelProperty(name = "activityTemplateId", value = "活动模板id，也是促销类别，目前是固定值。满折：1197154895685446734，满减：1197154895685446735，满返：1197154895685446736，满赠：1197154895685446737，加价购：1197154895685446738，储值赠礼：1197154895685446739，积分兑换：1197154895685446740")
    private Long activityTemplateId;

    @ApiModelProperty(name = "activityItemRange", value = "促销大类,ALL 整单、COLLECTION 集合、ITEM 单品")
    private String activityItemRange;

    @ApiModelProperty(name = "activityName", value = "活动名称")
    private String activityName;

    @ApiModelProperty(name = "updateAcc", value = "更新账号")
    private String updateAcc;

    @ApiModelProperty(name = "activityStatusEnum", value = "活动状态")
    private ActivityStatusEnum activityStatusEnum;

    @ApiModelProperty(name = "auditPerson", value = "审核人")
    private String auditPerson;

    @ApiModelProperty(name = "mutexLevelStart", value = "权重起点")
    private Integer mutexLevelStart;

    @ApiModelProperty(name = "mutexLevelEnd", value = "权重终点")
    private Integer mutexLevelEnd;

    /**
     * 活动预热开始时间查询
     */
    @ApiModelProperty(name = "selectPreheatStartTime", value = "活动预热开始时间查询条件")
    private Date selectPreheatStartTime;

    /**
     * 活动预热结束时间查询
     */
    @ApiModelProperty(name = "selectPreheatEndTime", value = "活动预热结束时间查询条件")
    private Date selectPreheatEndTime;

    /**
     * 活动范围：1-平台， 2-商家
     */
    @ApiModelProperty(name = "activityRange", value = "活动范围：1-平台， 2-商家")
    private Integer activityRange;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getBeginTime() {
        return beginTime;
    }

    public void setBeginTime(Date beginTime) {
        this.beginTime = beginTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getActivityName() {
        return activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public String getUpdateAcc() {
        return updateAcc;
    }

    public void setUpdateAcc(String updateAcc) {
        this.updateAcc = updateAcc;
    }

    public Long getActivityTemplateId() {
        return activityTemplateId;
    }

    public void setActivityTemplateId(Long activityTemplateId) {
        this.activityTemplateId = activityTemplateId;
    }

    public ActivityStatusEnum getActivityStatusEnum() {
        return activityStatusEnum;
    }

    public void setActivityStatusEnum(ActivityStatusEnum activityStatusEnum) {
        this.activityStatusEnum = activityStatusEnum;
    }

    public String getAuditPerson() {
        return auditPerson;
    }

    public void setAuditPerson(String auditPerson) {
        this.auditPerson = auditPerson;
    }

    public Integer getMutexLevelStart() {
        return mutexLevelStart;
    }

    public void setMutexLevelStart(Integer mutexLevelStart) {
        this.mutexLevelStart = mutexLevelStart;
    }

    public Integer getMutexLevelEnd() {
        return mutexLevelEnd;
    }

    public void setMutexLevelEnd(Integer mutexLevelEnd) {
        this.mutexLevelEnd = mutexLevelEnd;
    }

    public String getActivityItemRange() {
        return activityItemRange;
    }

    public void setActivityItemRange(String activityItemRange) {
        this.activityItemRange = activityItemRange;
    }

    public Date getBeginTimeStart() {
        return beginTimeStart;
    }

    public void setBeginTimeStart(Date beginTimeStart) {
        this.beginTimeStart = beginTimeStart;
    }

    public Date getBeginTimeEnd() {
        return beginTimeEnd;
    }

    public void setBeginTimeEnd(Date beginTimeEnd) {
        this.beginTimeEnd = beginTimeEnd;
    }

    public Date getSelectPreheatStartTime() {
        return selectPreheatStartTime;
    }

    public void setSelectPreheatStartTime(Date selectPreheatStartTime) {
        this.selectPreheatStartTime = selectPreheatStartTime;
    }

    public Date getSelectPreheatEndTime() {
        return selectPreheatEndTime;
    }

    public void setSelectPreheatEndTime(Date selectPreheatEndTime) {
        this.selectPreheatEndTime = selectPreheatEndTime;
    }

    public Integer getActivityRange() {
        return activityRange;
    }

    public void setActivityRange(Integer activityRange) {
        this.activityRange = activityRange;
    }
}
