/*
 * *
 *  * @(#)PromotionRulesDto.java 2.0.0 7/4/19 2:22 PM
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request;

import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.constants.enums.ObjectType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.constants.enums.ReturnType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.utils.MapUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.util.StringUtils;

import javax.persistence.Transient;
import java.math.BigDecimal;
import java.util.Map;

/**
 * TODO 需要映射的字段全部需要进行enum化 不然会出现很多魔法数字 不好管理
 *
 * @author luo.lei
 * @since 2.0.0
 */
@ApiModel(description = "规则")
public class PromotionRulesDto implements ConditionDto, Comparable<PromotionRulesDto> {

    /**
     * 促销条件 0.等于 1.满 2.每满 3.阶梯
     */
    @ApiModelProperty(value = "促销条件 0.等于 1.满 2.每满 3.阶梯")
    private int condition;

    /**
     * 促销条件数量
     */
    @ApiModelProperty(value = "促销条件数量")
    private BigDecimal limitAmount;

    /**
     * 促销条件类型 1.元 2.件
     */
    @ApiModelProperty(value = "促销条件类型 1.元 2.件")
    private int priceType;

    /**
     * 折扣类型 0 积分 1 券 2.商品 3.包邮 4.储值卡 5.打折 6.减免 7.加价购
     */
    @ApiModelProperty(value = "折扣类型  积分  券  商品 包邮 储值卡 打折 减免 加价购")
    private ReturnType returnType;

    /**
     * 折扣数量
     */
    @ApiModelProperty(value = "折扣数量")
    private String discountValue;


    /**
     * 商品或券ID
     */
    @ApiModelProperty(value = "商品或券ID")
    private long objectId;

    @ApiModelProperty(value = "商品或券code")
    private String objCode;

    @ApiModelProperty(value = "商品或券名称")
    private String name;

    /**
     * 商品库存
     */
    @ApiModelProperty(value = "objectStock")
    private int objectStock;

    /**
     * 赠品组ID
     */
    @ApiModelProperty(value = "赠品组ID")
    private long objectGroupId;

    @ApiModelProperty(value = "赠品组名称")
    private String groupName;

    /**
     * 是否随机
     */
    @ApiModelProperty(value = "是否随机")
    private boolean random;

    @ApiModelProperty(value = "加价购加价金额")
    private String addPrice;

    @Transient
    /**
     * 赠品类型  1 单品  2 赠品组
     */
    @ApiModelProperty(value = "赠品类型  SINGLE 单品  GROUP 赠品组")
    private ObjectType objectType;

    /**
     * 优惠券类型
     */
    @ApiModelProperty(value = "")
    private String couponType;

    public PromotionRulesDto() {
    }

    public static PromotionRulesDto defaultInstance(Map<String, Object> condition) {
        PromotionRulesDto rulesDto = new PromotionRulesDto();
        rulesDto.setCondition(MapUtils.getIntValue(condition, "condition"));
        rulesDto.setLimitAmount(MapUtils.getBigDecimal(condition, "limitAmount"));
        rulesDto.setPriceType(MapUtils.getIntValue(condition, "priceType"));
        rulesDto.setReturnType(ReturnType.valueOf(MapUtils.getString(condition, "returnType")));
        // 单品还是赠品组
        String objType = MapUtils.getString(condition, "objectType");
        if (!StringUtils.isEmpty(objType)) {
            rulesDto.setObjectType(ObjectType.valueOf(objType));
        }
        // 积分还是优惠券

        return rulesDto;
    }

    public ObjectType getObjectType() {
        return objectType;
    }

    public void setObjectType(ObjectType objectType) {
        this.objectType = objectType;
    }

    public String getAddPrice() {
        return addPrice;
    }

    public void setAddPrice(String addPrice) {
        this.addPrice = addPrice;
    }

    public int getCondition() {
        return condition;
    }

    public void setCondition(int condition) {
        this.condition = condition;
    }

    public BigDecimal getLimitAmount() {
        return limitAmount;
    }

    public void setLimitAmount(BigDecimal limitAmount) {
        this.limitAmount = limitAmount;
    }

    public int getPriceType() {
        return priceType;
    }

    public void setPriceType(int priceType) {
        this.priceType = priceType;
    }

    public ReturnType getReturnType() {
        return returnType;
    }

    public void setReturnType(ReturnType returnType) {
        this.returnType = returnType;
    }

    public String getDiscountValue() {
        return discountValue;
    }

    public void setDiscountValue(String discountValue) {
        this.discountValue = discountValue;
    }

    public long getObjectId() {
        return objectId;
    }

    public void setObjectId(long objectId) {
        this.objectId = objectId;
    }

    public int getObjectStock() {
        return objectStock;
    }

    public void setObjectStock(int objectStock) {
        this.objectStock = objectStock;
    }

    public long getObjectGroupId() {
        return objectGroupId;
    }

    public void setObjectGroupId(long objectGroupId) {
        this.objectGroupId = objectGroupId;
    }

    public boolean isRandom() {
        return random;
    }

    public void setRandom(boolean random) {
        this.random = random;
    }

    public String getCouponType() {
        return couponType;
    }

    public void setCouponType(String couponType) {
        this.couponType = couponType;
    }

    public String getObjCode() {
        return objCode;
    }

    public void setObjCode(String objCode) {
        this.objCode = objCode;
    }

    public String getGroupName() {
        return groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int compareTo(PromotionRulesDto o) {
        return o.getLimitAmount().compareTo(this.limitAmount);
    }
}
