/*
 * *
 *  * @(#)PromotionRulesPointDto.java 2.0.0 7/4/19 3:35 PM
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * 积分兑换规则
 *
 * @author luo.lei
 * @since 2.0.0
 */
@ApiModel
public class PromotionRulesPointDto implements ConditionDto {

    @ApiModelProperty(name = "type", value = "兑换类型 1.兑换商品 2.兑换优惠券")
    private int type;

    @ApiModelProperty(name = "joinMax", value = "最大参与次数")
    private int joinMax;

    @ApiModelProperty(name = "salesPrice", value = "销售价格")
    private BigDecimal salesPrice;

    @ApiModelProperty(name = "point", value = "积分")
    private int point;

    @ApiModelProperty(name = "price", value = "金额")
    private BigDecimal price;

    /**
     * 兑换物品名称
     */
    @ApiModelProperty(name = "objName", value = "兑换物品名称")
    private String objName;

    /**
     * 兑换物品描述
     */
    @ApiModelProperty(name = "objDesc", value = "兑换物品描述")
    private String objDesc;

    @ApiModelProperty(name = "objCode", value = "产品或者优惠券code")
    private String objCode;

    @ApiModelProperty(name = "objId", value = "产品或者优惠券id")
    private Long objId;

    @ApiModelProperty(name = "objType", value = "产品或者优惠券类型")
    private String objType;

    public PromotionRulesPointDto() {
    }

    public BigDecimal getSalesPrice() {
        return salesPrice;
    }

    public void setSalesPrice(BigDecimal salesPrice) {
        this.salesPrice = salesPrice;
    }

    public int getPoint() {
        return point;
    }

    public void setPoint(int point) {
        this.point = point;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public String getObjName() {
        return objName;
    }

    public void setObjName(String objName) {
        this.objName = objName;
    }

    public String getObjDesc() {
        return objDesc;
    }

    public void setObjDesc(String objDesc) {
        this.objDesc = objDesc;
    }

    public String getObjCode() {
        return objCode;
    }

    public void setObjCode(String objCode) {
        this.objCode = objCode;
    }

    public String getObjType() {
        return objType;
    }

    public void setObjType(String objType) {
        this.objType = objType;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getJoinMax() {
        return joinMax;
    }

    public void setJoinMax(int joinMax) {
        this.joinMax = joinMax;
    }

    public Long getObjId() {
        return objId;
    }

    public void setObjId(Long objId) {
        this.objId = objId;
    }
}
