package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.response;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 赠品详情vo
 *
 * @author chen.fangliang
 * @date 2019/7/9 19:03
 */
@ApiModel(value = "PresentDetailRespDto", description = "赠品组详情Dto")
public class PresentDetailExtRespDto extends BaseVo {

    @ApiModelProperty(name = "id", value = "赠品组id")
    private Long id;

    @ApiModelProperty(name = "name", value = "赠品组名称")
    private String name;

    @ApiModelProperty(name = "type", value = "促销大类")
    private String type;

    @ApiModelProperty(name = "presentList", value = "赠品明细")
    private List<PresentListDto> presentList;

    @ApiModel(value = "PresentListDto", description = "赠品组列表详情Dto")
    public static class PresentListDto {

        @ApiModelProperty(name = "objId", value = "对象id")
        private String objId;

        @ApiModelProperty(name = "id", value = "明细id，更新时需要传")
        private Long id;

        @ApiModelProperty(name = "code", value = "编号")
        private String code;

        @ApiModelProperty(name = "name", value = "名称")
        private String name;

        @ApiModelProperty(name = "type", value = "优惠券类型, 01=团购券, 02=APP提货券, 03=福利券, 04=客情券, 05=优惠券")
        private String type;

        @ApiModelProperty(name = "maxSendNum", value = "最大发放量-券")
        private Long maxSendNum;

        @ApiModelProperty(name = "sendNum", value = "已发送量-券")
        private Long sendNum;

        @ApiModelProperty(name = "num", value = "赠送数量-商品")
        private Integer num;

        @ApiModelProperty(name = "stock", value = "库存-商品")
        private Long stock;

        public Long getId() {
            return id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getCode() {
            return code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Long getMaxSendNum() {
            return maxSendNum;
        }

        public void setMaxSendNum(Long maxSendNum) {
            this.maxSendNum = maxSendNum;
        }

        public Long getSendNum() {
            return sendNum;
        }

        public void setSendNum(Long sendNum) {
            this.sendNum = sendNum;
        }

        public Integer getNum() {
            return num;
        }

        public void setNum(Integer num) {
            this.num = num;
        }

        public Long getStock() {
            return stock;
        }

        public void setStock(Long stock) {
            this.stock = stock;
        }

        public String getObjId() {
            return objId;
        }

        public void setObjId(String objId) {
            this.objId = objId;
        }
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<PresentListDto> getPresentList() {
        return presentList;
    }

    public void setPresentList(List<PresentListDto> presentList) {
        this.presentList = presentList;
    }
}
