package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.service;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.constants.enums.PresentReferEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.PresentReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.Min;

/**
 * @author chen. fangliang
 * @date 2019/7/9 14:18
 */
@Api(tags = {"促销中心:赠品组api"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-marketing-api-activity-promotion-service-IPresentApi", 
        name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}",
        url = "${yundt.cube.center.promotion.api:}",
        path = "/v2/present"
)
public interface IPresentApi {

    /**
     * 增加赠品组
     *
     * @param reqDto 新增组请求
     * @return 返回组id
     */
    @PostMapping({""})
    @ResponseBody
    @ApiOperation(value = "新增赠品组", notes = "新增赠品组")
    RestResponse<Long> addPresentGroup(@RequestBody @Valid PresentReqDto reqDto);

    /**
     * 更新赠品组
     *
     * @param id     赠品组id
     * @param reqDto 新增组请求
     * @return 返回组id
     */
    @PutMapping({"/{id}"})
    @ResponseBody
    @ApiOperation(value = "根据赠品组id更新赠品组", notes = "根据赠品组id更新赠品组")
    RestResponse<Void> modifyPresentGroup(@Min(value = 1L, message = "id非法") @PathVariable("id") Long id, @RequestBody @Valid PresentReqDto reqDto);

    /**
     * 删除赠品组
     *
     * @param id 赠品组id
     * @return 返回组id
     */
    @DeleteMapping({"/{id}"})
    @ResponseBody
    @ApiOperation(value = "根据赠品组id删除赠品组", notes = "根据赠品组id删除赠品组")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "赠品组id", dataType = "Long", paramType = "path"),
            @ApiImplicitParam(name = "checkRefer", value = "是否判断引用关系,true:判断赠品组是否被其他促销活动等引用中,如果被引用中则无法删除,false:不判断则直接删除", dataType = "boolean", paramType = "query")
    })
    RestResponse<Void> deletePresentGroup(@Min(value = 1L, message = "id非法") @PathVariable("id") Long id,
                                          @RequestParam("checkRefer") boolean checkRefer);

    /**
     * 设置被引用
     *
     * @param id    组id
     * @param refer 引用枚举
     */
    @GetMapping({"/refer/{id}"})
    @ApiOperation(value = "设置赠品组引用状态", notes = "设置引用")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "赠品组id", dataType = "Long", paramType = "path"),
            @ApiImplicitParam(name = "refer", value = "是否引用关系 0:未引用  1:已被引用", dataType = "int", paramType = "query")
    })
    RestResponse<Void> refer(@Min(value = 1L, message = "id非法") @PathVariable("id") Long id, @RequestParam("refer") PresentReferEnum refer);

}
