/*
 * *
 *  * @(#)IPromotionService.java 2.0.0 7/4/19 1:46 PM
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.service;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.PromotionDepositInfoDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.PromotionInfoDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.PromotionPointInfoDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * @author luo.lei
 * @since 2.0.0
 */
@Api(tags = {"促销中心:促销查询服务接口API"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-marketing-api-activity-promotion-service-IPromotionApi", name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}", path = "/v1/center-promotion", url = "${yundt.cube.center.promotion.api:}")
public interface IPromotionApi {

    /**
     * 新增促销活动
     *
     * @param addPromotion 活动信息
     * @return 活动ID
     */
    @PostMapping("")
    @ApiOperation(value = "促销活动新增", notes = "促销活动新增")
    RestResponse<Long> add(@Valid @RequestBody PromotionInfoDto addPromotion);


    /**
     * 修改促销活动信息
     *
     * @param promotionId     活动ID
     * @param updatePromotion 修改信息 除了PromotionBaseInfoDto其他信息修改时需要完整信息
     */
    @RequestMapping(value = "/{promotionId}", method = RequestMethod.PUT)
    @ApiOperation(value = "根据促销活动id修改促销活动信息", notes = "根据促销活动id修改促销活动信息")
    RestResponse<Void> updatePromotion(@PathVariable("promotionId") long promotionId, @Valid @RequestBody PromotionInfoDto updatePromotion);

    /**
     * 修改积分兑换活动信息
     *
     * @param promotionId     活动ID
     * @param updatePromotion 修改信息 除了PromotionBaseInfoDto其他信息修改时需要完整信息
     */
    @RequestMapping(value = "points/{promotionId}", method = RequestMethod.PUT)
    @ApiOperation(value = "根据促销活动id修改积分兑换活动", notes = "积分兑换活动修改")
    RestResponse<Void> updatePromotion(@PathVariable("promotionId") long promotionId, @Valid @RequestBody PromotionPointInfoDto updatePromotion);


    /**
     * 修改储值赠礼活动信息
     *
     * @param promotionId     活动ID
     * @param updatePromotion 修改信息 除了PromotionBaseInfoDto其他信息修改时需要完整信息
     */
    @RequestMapping(value = "deposit/{promotionId}", method = RequestMethod.PUT)
    @ApiOperation(value = "根据促销活动id修改储值赠礼活动", notes = "根据促销活动id修改储值赠礼活动")
    RestResponse<Void> updatePromotion(@PathVariable("promotionId") long promotionId, @Valid @RequestBody PromotionDepositInfoDto updatePromotion);

    /**
     * 新增积分兑换活动
     * @param addPromotion 积分兑换活动信息
     * @return 活动ID
     */
    @PostMapping("points")
    @ApiOperation(value = "积分兑换活动新增", notes = "积分兑换活动新增")
    RestResponse<Long> addRedeemPoints(@Valid @RequestBody PromotionPointInfoDto addPromotion);

    @PostMapping("deposit")
    @ApiOperation(value = "储值赠礼活动新增", notes = "储值赠礼活动新增")
    RestResponse<Long> addRedeemDeposit(@Valid @RequestBody PromotionDepositInfoDto addPromotion);


}
