package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.service;

import com.dtyunxi.rest.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Map;

/**
 * @author diyun
 * @since 1.0.0
 */
@Api(tags = {"促销中心:主动营销订单同步相关接口"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-marketing-api-activity-promotion-service-ITradeSyncProcessApi", name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}",
        path = "/v1/tradeSyncProcess",
        url = "${yundt.cube.center.promotion.api:}")
public interface ITradeSyncProcessApi {

    @PostMapping("/sync")
    @ApiOperation(
            value = "外单订单同步赠送促销积分",
            notes = "订单同步赠送促销积分_(标品定制json字符串)"
    )
    @Deprecated
    RestResponse<Map<String,Object>> processTradeInfo(@RequestParam("tradeInfoJson") String tradeInfoJson);
}
