package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.service.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.response.PresentDetailRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.response.PresentListRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author chen.fangliang
 * @date 2019/7/9 16:42
 */
@Api(tags = {"促销中心:赠品查询服务"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-marketing-api-activity-promotion-service-query-IPresentQueryApi", 
        name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}",
        path = "/v2/present",
        url = "${yundt.cube.center.promotion.api:}"
)
public interface IPresentQueryApi {

    /**
     * 分页查询赠品列表
     *
     * @param filters
     * @param pageNum
     * @param pageSize
     * @return
     */
    @GetMapping({"/list"})
    @ApiOperation(value = "条件分页查询赠品列表", notes = "根据查询条件查询赠品列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNum", value = "当前页面", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "pageSize", value = "页面大小", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "filters", value = "查询条件,例如:{\"name\":\"test\"},可以拼接多个条件,如果没有查询条件则传入{}", dataType = "String", paramType = "query",required = true)
    })
    RestResponse<PageInfo<PresentListRespDto>> queryByPage(@RequestParam("filters") String filters,
                                                           @RequestParam("pageNum") Integer pageNum,
                                                           @RequestParam("pageSize") Integer pageSize);

    /**
     * 根据赠品组id查询赠品组详情
     *
     * @param id
     * @return
     */
    @GetMapping(value = {"/{id}"})
    @ApiOperation(value = "根据赠品组id查询赠品组详情", notes = "根据赠品组id查询赠品组详情")
    RestResponse<PresentDetailRespDto> queryDetailById(@PathVariable("id") Long id);
}
