package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.service.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.PromotionQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.response.PromotionInfoRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.response.PromotionListRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author chen.fangliang
 * @date 2019/7/4 14:54
 */
@Api(tags = {"促销中心:促销活动服务接口API"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-marketing-api-activity-promotion-service-query-IPromotionQueryApi", name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}", path = "/v1/center-promotion", url = "${yundt.cube.center.promotion.api:}")
public interface IPromotionQueryApi {


    /**
     * 分页查询促销列表
     *
     * @param reqDto
     * @param pageNum
     * @param pageSize
     * @return
     */
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    @ApiOperation(value = "查询促销活动分页列表", notes = "根据查询条件查询促销活动列表")
    RestResponse<PageInfo<PromotionListRespDto>> queryByPage(@SpringQueryMap PromotionQueryReqDto reqDto,
                                                             @RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                             @RequestParam(value = "pageSize", required = false, defaultValue = "10") Integer pageSize);


    /**
     * 根据活动id查询促销详细信息
     *
     * @param activityId
     * @return
     */
    @RequestMapping(value = "/{activityId}", method = RequestMethod.GET)
    @ApiOperation(value = "根据促销活动id查询促销活动详情", notes = "根据查询条件查询促销活动详情")
    RestResponse<PromotionInfoRespDto> queryDetail(@PathVariable("activityId") Long activityId);

}
