/**
 * @(#)ActivityStatusChangeMessage.java 1.0 2020/5/19
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.tag.dto;

import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityStatusEnum;

/**
 * 活动状态变更消息
 *
 * @author wu.sheng
 * @date 2020/5/19 15:39
 */
public class ActivityStatusChangeMessage extends BaseVo {

    /**
     * 消息tag
     */
    public static final String MESSAGE_TAG = "ACTIVITY_STATUS_CHANGE";

    /**
     * 活动id
     */
    private Long activityId;

    /**
     * 变更后活动状态
     */
    private ActivityStatusEnum activityStatus;

    /**
     * 业务id
     */
    private String bizId;

    /**
     * 重试次数
     */
    private Integer retryCount;

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public ActivityStatusEnum getActivityStatus() {
        return activityStatus;
    }

    public void setActivityStatus(ActivityStatusEnum activityStatus) {
        this.activityStatus = activityStatus;
    }

    public String getBizId() {
        return bizId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public Integer getRetryCount() {
        return retryCount == null ? 0 : retryCount;
    }

    public void setRetryCount(Integer retryCount) {
        this.retryCount = retryCount;
    }
}
