/**
 * @(#)IActivityCommonRest.java 1.0 2020/4/30
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg;


import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityAuditReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityListRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.group.ActivityQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.group.PageEditActivityReqDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;


/**
 * 活动基本操作服务
 *
 * @author wu.sheng
 * @date 2020/4/30 15:52
 */
@Api(tags = {"商城应用：活动服务"})
@FeignClient(contextId="com-dtyunxi-yundt-icom-bundle-base-center-promotion-api-agg-IActivityAggApi",
        name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}",
        path = "/v1/marketing/activity",
        url = "${yundt.cube.center.promotion.api:}")
public interface IActivityAggApi {


    @ApiOperation(value = "删除活动", notes = "未开始活动可删除")
    @DeleteMapping("/{id}")
    RestResponse<Void> delete(@PathVariable("id") Long id);

    @ApiOperation(value = "结束活动", notes = "手动结束活动，操作不可逆")
    @PutMapping("/{id}/closure")
    RestResponse<Void> closure(@PathVariable("id") Long id);

    @ApiOperation(value = "分页查询活动列表")
    @GetMapping("/list")
    RestResponse<PageInfo<ActivityListRespDto>> queryByPage(ActivityQueryReqDto activityQueryReqDto, Integer pageNum,
                                                            Integer pageSize);

    /**
     * 根据模板id分页查询活动列表
     *
     * @param queryDto
     * @param pageNum
     * @param pageSize
     * @return
     */
    @GetMapping("/pageByTemplate")
    @ApiOperation(value = "根据模板id分页查询活动列表", notes = "根据模板id分页查询活动列表")
    RestResponse<PageInfo<ActivityRespDto>> pageByTemplate(@ModelAttribute ActivityDto queryDto,
                                                           @RequestParam(value = "pageNum", required = false,
                                                                   defaultValue = "1") Integer pageNum,
                                                           @RequestParam(value = "pageSize", required = false,
                                                                   defaultValue = "100") Integer pageSize);

    @ApiOperation(value = "审核活动", notes = "审核活动")
    @PostMapping("/{id}/audit")
    RestResponse<Void> audit(@PathVariable("id") Long id, @RequestBody ActivityAuditReqDto activityAuditReqDto);

    @ApiOperation(value = "装修页面组件自动获取活动")
    @GetMapping("/pageEdit")
    RestResponse<ActivityListRespDto> queryActivity(@ModelAttribute PageEditActivityReqDto pageEditActivityReqDto);

}
