/**
 * @(#)CouponRest.java 1.0 2019/11/18
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponPushRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.common.CouponTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.coupon.*;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.response.*;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.math.BigDecimal;
import java.util.List;

@Api(tags = {"商城应用：优惠券服务"})
@FeignClient(contextId="com-dtyunxi-yundt-icom-bundle-base-center-promotion-api-agg-ICouponAggApi",
        name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}",
        path = "/v1/marketing/coupon",
        url = "${yundt.cube.center.promotion.api:}")
public interface ICouponAggApi {

    /**
     * 新增优惠券模板
     *
     * @param couponTemplate
     * @date 2019/11/18 16:43
     */
    @ApiOperation(value = "新增优惠券模板")
    @ApiImplicitParam(name = "couponTemplate", paramType = "body", dataType = "CouponTemplate",
            required = true, value = "优惠券信息")
    @PostMapping("/template")
    RestResponse<Long> create(@Valid @RequestBody CouponTemplate couponTemplate);

    /**
     * 分页查询优惠券模板列表(mgmt)
     *
     * @param couponTemplate
     * @param pageNum
     * @param pageSize
     * @date 2019/11/19 11:22e
     */
    @ApiOperation(value = "分页查询优惠券模板列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNum", dataType = "Int", paramType = "query", required = true),
            @ApiImplicitParam(name = "pageSize", dataType = "Int", paramType = "query", required = true)
    })
    @GetMapping("/template/list")
    RestResponse<PageInfo<CouponTemplate>> query(CouponTemplate couponTemplate,
                                                 @RequestParam(value = "pageNum", defaultValue = "1") Integer pageNum,
                                                 @RequestParam(value = "pageSize", defaultValue = "10") Integer pageSize);

    /**
     * 优惠券模板详情
     *
     * @param id 模板id
     * @date 2019/11/19 11:24
     */
    @ApiOperation(value = "优惠券模板详情", notes = "根据模板id查询优惠券模板")
    @ApiImplicitParam(name = "id", paramType = "path", dataType = "Int", value = "优惠券模板id", required = true)
    @GetMapping("/template/{id}")
    RestResponse<CouponTemplateDetailRespDto> getById(@PathVariable("id") Long id);

    /**
     * 分页查询优惠券模板领取记录
     *
     * @param couponReceiveRecordReqDto
     * @param pageNum
     * @param pageSize
     * @date 2019/11/19 14:13
     */
    @ApiOperation(value = "分页查询优惠模板领取记录")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNum", dataType = "Int", paramType = "query", required = true),
            @ApiImplicitParam(name = "pageSize", dataType = "Int", paramType = "query", required = true)
    })
    @GetMapping("/template/receiveRecord/list")
    RestResponse<PageInfo<CouponExtRespDto>> queryCoupon(CouponReceiveRecordReqDto couponReceiveRecordReqDto,
                                                         @RequestParam(value = "pageNum", defaultValue = "1") Integer pageNum,
                                                         @RequestParam(value = "pageSize", defaultValue = "10") Integer pageSize);

    /**
     * 启用优惠券模板
     *
     * @param id
     * @date 2019/11/19 13:54
     */
    @ApiOperation(value = "启用优惠券模板")
    @ApiImplicitParam(name = "id", paramType = "path", dataType = "Int",
            value = "优惠券模板id", required = true)
    @PutMapping("/template/{id}/enable")
    RestResponse<Void> enable(@PathVariable("id") Long id);

    /**
     * 停用优惠券模板
     *
     * @param id
     * @date 2019/11/19 15:43
     */
    @ApiOperation(value = "禁用优惠券模板")
    @ApiImplicitParam(name = "id", paramType = "path", dataType = "Int",
            value = "优惠券模板id", required = true)
    @PutMapping("/template/{id}/disable")
    RestResponse<Void> disable(@PathVariable("id") Long id);

    /**
     * 优惠券模板失效
     *
     * @param ids 模板id
     * @date 2019/11/19 13:59
     */
    @ApiOperation(value = "批量作废优惠券模板", notes = "批量作废，模板ids,多个逗号隔开")
    @PutMapping("/template/invalid")
    RestResponse<Void> invalid(String ids);


    /**
     * 优惠券发放给指定会员
     *
     * @param couponGrantReqDto
     * @date 2019/11/19 16:17
     */
    @ApiOperation(value = "优惠券发放", notes = "优惠券发放给指定会员")
    @ApiImplicitParam(name = "couponGrantReqDto", dataType = "CouponGrantReqDto", paramType = "body",
            required = true, value = "优惠券发放参数")
    @PostMapping("/grant")
    RestResponse<Void> grant(@Valid @RequestBody CouponGrantReqDto couponGrantReqDto);


    @ApiOperation(value = "查询优惠模板券列表（商城）")
    @GetMapping("/platform/gather/page")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNum", dataType = "Int", paramType = "query", value = "当前页"),
            @ApiImplicitParam(name = "pageSize", dataType = "Int", paramType = "query", value = "页大小")
    })
    RestResponse<PageInfo<CouponTemplate>> platFormCouponGather(CouponTemplateExtQueryReqDto queryReqDto,
                                                                @RequestParam("pageNum") Integer pageNum,
                                                                @RequestParam("pageSize") Integer pageSize);

    @ApiOperation(value = "查询店铺下可领取的优惠券列表")
    @GetMapping("/gather/list")
    @ApiImplicitParam(name = "shopId", dataType = "Long", paramType = "query", value = "店铺id")
    RestResponse<List<CouponTemplate>> couponGather(@RequestParam(value = "shopId") String shopId);

    @ApiOperation(value = "查看会员下的优惠券")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNum", dataType = "Int", paramType = "query", value = "当前页"),
            @ApiImplicitParam(name = "pageSize", dataType = "Int", paramType = "query", value = "页大小")
    })
    @GetMapping("/personal/page")
    RestResponse<PageInfo<CouponRespDto>> queryCouponPage(@RequestParam("pageNum") Integer pageNum,
                                                          @RequestParam("pageSize") Integer pageSize);


    @ApiOperation(value = "用户领取优惠券")
    @ApiImplicitParam(name = "couponTemplateId", dataType = "Long", paramType = "query", value = "优惠券模板id")
    @GetMapping("/receive")
    RestResponse<CouponPushRespDto> receiveCoupon(@RequestParam("couponTemplateId") Long couponTemplateId);


    @ApiOperation(value = "优惠券详情(商城端)")
    @ApiImplicitParam(name = "id", paramType = "path", dataType = "Int", value = "优惠券id", required = true)
    @GetMapping("/detail/{id}")
    RestResponse<CouponDetailRespDto> getCouponById(@PathVariable("id") Long id);


    @ApiOperation(value = "根据模板id列表批量查询优惠券模板信息")
    @PostMapping("/template/list")
    RestResponse<List<CouponTemplate>> queryByIds(@RequestBody List<Long> ids);
}
