/**
 * @(#)IExchangeActivityAggApi.java 1.0 2021/7/28
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.exchange.ExchangeActivityDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

@Api(tags = {"商城应用：换购活动服务"})
@FeignClient(contextId="com-dtyunxi-yundt-icom-bundle-base-center-promotion-api-agg-IExchangeActivityAggApi",
        name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}",
        path = "/v1/exchange/activity",
        url = "${yundt.cube.center.promotion.api:}")
public interface IExchangeActivityAggApi {

    @ApiOperation(value = "新增换购活动")
    @PostMapping("")
    RestResponse<Long> add(@Valid @RequestBody ExchangeActivityDto exchangeActivityDto);

    @ApiOperation(value = "换购活动详情")
    @GetMapping("/{id}")
    RestResponse<ExchangeActivityDto> getDetail(@PathVariable("id") Long id);

}
