/**
 * @(#)FullReduceActivityRest.java 1.0 2020/5/8
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.fullreduction.FullReductionActivityDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * 满减满折活动服务
 *
 * @author 伊泽
 * @since 1.0.0
 */
@Api(tags = {"商城应用：满减满折活动服务"})
@FeignClient(contextId="com-dtyunxi-yundt-icom-bundle-base-center-promotion-api-agg-IFullReductionActivityAggApi",
        name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}",
        path = "/v1/marketing/full/reduction",
        url = "${yundt.cube.center.promotion.api:}")
public interface IFullReductionActivityAggApi {

    @ApiOperation(value = "新增满减满折活动")
    @PostMapping("/activity")
    RestResponse<Long> add(@Valid @RequestBody FullReductionActivityDto fullReductionActivityDto);

    @ApiOperation(value = "活动详情")
    @GetMapping("/activity/{id}")
    @ApiImplicitParam(name = "id", paramType = "path", dataType = "Long", required = true, value = "活动id")
    RestResponse<FullReductionActivityDto> getDetail(@PathVariable("id") Long id);

}
