/**
 * @(#)GroupActivityRest.java 1.0 2020/4/10
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.group.ActivityQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.group.GroupActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.response.ActivityGroupListRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.response.ActivityTermDetailRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.response.GroupActivityQueryRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.crowdordering.dto.request.ActivityGroupReqDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * 拼团活动服务
 *
 * @author wu.sheng
 * @date 2020/4/11 15:53
 */
@Api(tags = {"商城应用：拼团活动服务"})
@FeignClient(contextId="com-dtyunxi-yundt-icom-bundle-base-center-promotion-api-agg-IGroupActivityAggApi",
        name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}",
        path = "/v1/marketing/group",
        url = "${yundt.cube.center.promotion.api:}")
public interface IGroupActivityAggApi {

    @ApiOperation(value = "新增拼团活动")
    @ApiImplicitParam(name = "groupActivityDto", paramType = "body", dataType = "GroupActivityReqDto",
            required = true, value = "拼团活动信息")
    @PostMapping("/activity")
    RestResponse<Long> add(@Valid @RequestBody GroupActivityDto groupActivityDto);

    @ApiOperation(value = "拼团活动详情")
    @GetMapping("/activity/{id}")
    RestResponse<GroupActivityDto> getDetail(@PathVariable("id") Long id);

    @ApiOperation(value = "分页查询拼团活动列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNum", dataType = "Int", paramType = "query"),
            @ApiImplicitParam(name = "pageSize", dataType = "Int", paramType = "query")
    })
    @GetMapping("/activity/list")
    RestResponse<PageInfo<GroupActivityQueryRespDto>> queryByPage(ActivityQueryReqDto activityQueryReqDto,
                                                                  @RequestParam(value = "pageNum",
                                                                          defaultValue = "1") Integer pageNum,
                                                                  @RequestParam(value = "pageSize", defaultValue =
                                                                          "10") Integer pageSize);

    @ApiOperation(value = "结束活动", notes = "手动结束活动，操作不可逆")
    @PutMapping("/activity/{id}/closure")
    RestResponse<Void> closure(@PathVariable("id") Long id);


    @ApiOperation(value = "分页查询拼团队伍列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNum", dataType = "Int", paramType = "query"),
            @ApiImplicitParam(name = "pageSize", dataType = "Int", paramType = "query")
    })
    @GetMapping("/activity-group/list")
    RestResponse<PageInfo<ActivityGroupListRespDto>> queryActivityGroupByPage(ActivityGroupReqDto activityGroupReqDto,
                                                                              @RequestParam(value = "pageNum",
                                                                                      defaultValue = "1") Integer pageNum,
                                                                              @RequestParam(value = "pageSize",
                                                                                      defaultValue = "10") Integer pageSize);


    @ApiOperation(value = "查询拼团队伍详情")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNum", dataType = "Int", paramType = "query"),
            @ApiImplicitParam(name = "pageSize", dataType = "Int", paramType = "query")
    })
    @GetMapping("/{groupId}/group-detail/list")
    RestResponse<ActivityTermDetailRespDto> queryGroupDetailByPage(@RequestHeader(value = "Access-Token", required = false) String accessToken,
                                                                   @PathVariable("groupId") Long groupId,
                                                                   @RequestParam(value = "pageNum", defaultValue = "1"
                                                                   ) Integer pageNum,
                                                                   @RequestParam(value = "pageSize", defaultValue =
                                                                           "10") Integer pageSize);

    @ApiOperation(value = "删除活动", notes = "未开始活动不可删除")
    @DeleteMapping("/activity/{id}")
    RestResponse<Void> delete(@PathVariable("id") Long id);

    @ApiOperation(value = "查询拼团是否成功", notes = "查询拼团是否成功")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "orderNo", dataType = "Int", paramType = "query")
    })
    @GetMapping("/groupSuccess/{orderNo}")
    RestResponse<Integer> queryGroupSuccess(@PathVariable("orderNo") String orderNo);
}
