package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg;


import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.returngift.ReturnGiftActivityDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;


/**
 * 满返满赠活动服务
 *
 * @author 伯约
 * @since 1.0.0
 */
@Api(tags = {"商城应用：满返满赠活动服务"})
@FeignClient(contextId="com-dtyunxi-yundt-icom-bundle-base-center-promotion-api-agg-IReturnGiftAggApi",
        name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}",
        path = "/v1/marketing/returngift",
        url = "${yundt.cube.center.promotion.api:}")
public interface IReturnGiftAggApi {

    @ApiOperation(value = "满返满赠活动")
    @PostMapping("/activity")
    RestResponse<Long> add(@Valid @RequestBody ReturnGiftActivityDto returnGiftActivityDto);

    @ApiOperation(value = "活动详情")
    @GetMapping("/activity/{id}")
    @ApiImplicitParam(name = "id", paramType = "path", dataType = "Long", required = true, value = "活动id")
    RestResponse<ReturnGiftActivityDto> getDetail(@PathVariable("id") Long id);

}
