/**
 * @(#)SeckillActivityRest.java 1.0 2020/4/30
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.seckill.SeckillActivityDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
 * 秒杀活动服务
 *
 * @author donghai
 * @date 2020/6/16 15:52
 */
@Api(tags = {"商城应用：秒杀活动服务"})
@FeignClient(contextId="com-dtyunxi-yundt-icom-bundle-base-center-promotion-api-agg-ISeckillActivityAggApi",
        name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}",
        path = "/v1/marketing/seckill",
        url = "${yundt.cube.center.promotion.api:}")
public interface ISeckillActivityAggApi {


    @ApiOperation(value = "新增秒杀活动")
    @ApiImplicitParam(name = "seckillActivityDto", paramType = "body", dataType = "SeckillActivityDto", required = true, value = "秒杀活动dto")
    @PostMapping("/activity")
    RestResponse<Long> add(@Valid @RequestBody SeckillActivityDto seckillActivityDto);

    @ApiOperation(value = "秒杀活动详情")
    @GetMapping("/activity/{id}")
    RestResponse<SeckillActivityDto> getDetail(@PathVariable("id") Long id);

}
