/**
 * @(#)TimeDiscountActivityRest.java 1.0 2020/4/30
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.timediscount.TimeDiscountActivityDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
 * 限时折扣活动服务
 *
 * @author wu.sheng
 * @date 2020/4/30 15:52
 */
@Api(tags = {"商城应用：限时折扣活动服务"})
@FeignClient(contextId="com-dtyunxi-yundt-icom-bundle-base-center-promotion-api-agg-ITimeDiscountActivityAggApi",
        name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}",
        path = "/v1/marketing/time-discount",
        url = "${yundt.cube.center.promotion.api:}")
public interface ITimeDiscountActivityAggApi {

    @ApiOperation(value = "新增限时折扣活动")
    @ApiImplicitParam(name = "timeDiscountActivityDto", paramType = "body", dataType = "TimeDiscountActivityDto",
            required = true, value = "限时折扣活动")
    @PostMapping("/activity")
    RestResponse<Long> add(@Valid @RequestBody TimeDiscountActivityDto timeDiscountActivityDto);

    @ApiOperation(value = "限时折扣活动详情")
    @GetMapping("/activity/{id}")
    RestResponse<TimeDiscountActivityDto> getDetail(@PathVariable("id") Long id);

}
