/**
 * @(#)ActivityItemRespDto.java 1.0 2020/4/15
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

/**
 * 活动商品响应dto
 *
 * @author 伊泽
 * @since 1.0.0
 */
@ApiModel(value = "ActivityItemInfoDto", description = "活动商品dto")
public class ActivityItemInfoDto {

    @ApiModelProperty(value = "itemId", name = "商品ID")
    private Long itemId;

    @ApiModelProperty(value = "price", name = "商品单价")
    private BigDecimal price;

    @ApiModelProperty(name = "优惠后的单价")
    private BigDecimal discountPrice;

    @ApiModelProperty(value = "skuId", name = "SKU id")
    private Long skuId;

    @ApiModelProperty(name = "业务自定义属性")
    private Map<String, Object> extendsAttribute = new HashMap(1);

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getDiscountPrice() {
        return discountPrice;
    }

    public void setDiscountPrice(BigDecimal discountPrice) {
        this.discountPrice = discountPrice;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public Map<String, Object> getExtendsAttribute() {
        return extendsAttribute;
    }

    public void setExtendsAttribute(Map<String, Object> extendsAttribute) {
        this.extendsAttribute = extendsAttribute;
    }
}
