/**
 * @(#)ActivityDto.java 1.0 2020/4/13
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.common;


import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityRelationReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;
import java.util.List;

/**
 * 活动基本信息
 *
 * @author wu.sheng
 * @date 2020/4/10 15:13
 */
@ApiModel(value = "BaseActivityDto", description = "活动基本信息")
public class BaseActivityDto {

    @ApiModelProperty(name = "id", value = "id")
    private Long id;

    @ApiModelProperty(name = "activityType", value = "活动类型: 拼团活动GROUP_ACTIVITYPE," +
            "限时折扣TIME_DISCOUNT_ACTIVITY，满折满减FULL_REDUCTION_ACTIVITY，秒杀活动SECKILL_ACTIVITY，满返FULL_RETURNING_ACTIVITY，满赠FULL_PRESENT_ACTIVITY")
    private ActivityType activityType;

    @ApiModelProperty(name = "activityName", value = "活动名称")
    private String activityName;

    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    @ApiModelProperty(name = "beginTime", value = "开始时间")
    private Date beginTime;

    @ApiModelProperty(name = "endTime", value = "截止时间")
    private Date endTime;

    @ApiModelProperty(name = "preheatStartTime", value = "预热开始时间")
    private Date preheatStartTime;

    @ApiModelProperty(name = "activityCode", value = "活动编码")
    private String activityCode;

    @ApiModelProperty(name = "tag", value = "活动标签")
    private String tag;

    @ApiModelProperty(name = "population", value = "人群")
    private PopulationDto population;

    /**
     * 促销方式（1：整单，2：单品）
     */
    @ApiModelProperty(name = "promotionMethod", value = "促销方式：1 整单，2 单品")
    private Integer promotionMethod;

    /**
     * 组织id
     */
    @ApiModelProperty(name = "organizationId", value = "组织id")
    private Long organizationId;

    /**
     * 组织名称
     */
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;

    @ApiModelProperty(name = "organizationIds", value = "所属组织Id集合")
    private List<Long> organizationIds;

    @ApiModelProperty(name = "returnGoods", value = "赠品售后：true需退货，false不需要退货")
    private Boolean returnGoods;

    @ApiModelProperty(name = "relationReqDtos", value = "活动关系")
    List<ActivityRelationReqDto> relationReqDtos;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getActivityName() {
        return activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Date getBeginTime() {
        return beginTime;
    }

    public void setBeginTime(Date beginTime) {
        this.beginTime = beginTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public ActivityType getActivityType() {
        return activityType;
    }

    public void setActivityType(ActivityType activityType) {
        this.activityType = activityType;
    }

    public Date getPreheatStartTime() {
        return preheatStartTime;
    }

    public void setPreheatStartTime(Date preheatStartTime) {
        this.preheatStartTime = preheatStartTime;
    }

    public String getTag() {
        return tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public BaseActivityDto() {

    }

    public BaseActivityDto(ActivityRespDto activityDto) {
        this.activityName = activityDto.getActivityName();
        this.activityType = ActivityType.getByType(activityDto.getActivityTemplateId());
        this.beginTime = activityDto.getBeginTime();
        this.endTime = activityDto.getEndTime();
        this.id = activityDto.getId();
        this.remark = activityDto.getRemark();
        this.activityCode = activityDto.getActivityCode();
        this.tag = activityDto.getTag();
        this.organizationId = activityDto.getOrganizationId();
        this.organizationName = activityDto.getOrganizationName();
    }

    public String getActivityCode() {
        return activityCode;
    }

    public void setActivityCode(String activityCode) {
        this.activityCode = activityCode;
    }

    public PopulationDto getPopulation() {
        return population;
    }

    public void setPopulation(PopulationDto population) {
        this.population = population;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public List<Long> getOrganizationIds() {
        return organizationIds;
    }

    public void setOrganizationIds(List<Long> organizationIds) {
        this.organizationIds = organizationIds;
    }

    public Integer getPromotionMethod() {
        return promotionMethod;
    }

    public void setPromotionMethod(Integer promotionMethod) {
        this.promotionMethod = promotionMethod;
    }

    public Boolean getReturnGoods() {
        return returnGoods;
    }

    public void setReturnGoods(Boolean returnGoods) {
        this.returnGoods = returnGoods;
    }

    public List<ActivityRelationReqDto> getRelationReqDtos() {
        return relationReqDtos;
    }

    public void setRelationReqDtos(List<ActivityRelationReqDto> relationReqDtos) {
        this.relationReqDtos = relationReqDtos;
    }
}
