/**
 * @(#)CouponTemplate.java 1.0 2019/11/19
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.common;

import com.alibaba.fastjson.annotation.JSONField;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.coupon.CouponItemDto;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 优惠券模板
 *
 * @author wu.sheng
 * @date 2019/11/19 9:31
 */
@ApiModel(value = "CouponTemplate", description = "优惠券模板")
public class CouponTemplate extends BaseActivityDto {

    private Long id;

    @ApiModelProperty(name = "activityId", value = "活动id")
    private Long activityId;

    @ApiModelProperty(name = "couponCode", value = "优惠券编码")
    private String couponCode;

    @ApiModelProperty(name = "couponName", value = "优惠券名称")
    @NotNull
    private String couponName;

    @ApiModelProperty(name = "couponRange", value = "券范围类型：10=平台券，20=店铺券")
    private Integer couponRange;

    @ApiModelProperty(name = "remark", value = "说明")
    private String remark;

    @ApiModelProperty(name = "couponCategory", value = "券类别, 10=定额现金券（满减）, 50=满折券, 40=兑换券（提货券）")
    @NotNull
    private Integer couponCategory;

    @ApiModelProperty(name = "couponValue", value = "面值（单位：元或百分比）")
    @Range(min = 0, max = 10000000)
    private BigDecimal couponValue;

    @ApiModelProperty(name = "amount", value = "优惠券金额阀值")
    @Range(min = 0, max = 10000000)
    private BigDecimal amount;

    @ApiModelProperty(name = "totalIssueQuantity", value = "发放总数量")
    @Range(min = 1, max = 10000000)
    private Long totalIssueQuantity;

    @ApiModelProperty(name = "couponUseTimeReqDto", value = "优惠券使用时间范围定义")
    //@NotNull(message = "优惠券使用时间范围未定义")
    private CouponUseTimeDto couponUseTimeReqDto;

    @ApiModelProperty(
            name = "couponUseTimeType",
            value = "优惠券使用时间定义 0时间区间 1=领券当天起第N天可用 2=领券次日起第N天可用 3永久可用"
    )
    @JsonIgnore
    @JSONField(serialize = false)
    private Byte couponUseTimeType;

    @ApiModelProperty(
            name = "couponUseTimeValue",
            value = "优惠券使用时间定义 couponUseTimeType=0不使用该字段 couponUseTimeType=1领券当天起第N天可用的N值 couponUseTimeType=2领券次日起第N天可用的N值 couponUseTimeType=3该值为0"
    )
    @JsonIgnore
    @JSONField(serialize = false)
    private String couponUseTimeValue = "0";

    @ApiModelProperty(name = "couponUseBeginTime", value = "优惠券使用开始时间 该字段已经不再使用")
    //@NotNull
    private Date couponUseBeginTime;

    @ApiModelProperty(name = "couponUseEndTime", value = "优惠券使用结束时间 该字段已经不再使用")
    //@NotNull
    private Date couponUseEndTime;

    @ApiModelProperty(name = "sharedDiscountList", value = "共享优惠：1平台券与商家券同时使用，2与商家促销活动同时使用,多个[1,2]格式")
    private List<Integer> sharedDiscountList;

    @ApiModelProperty(name = "itemRange", value = "商品使用范围（SELLER：商户、SHOP：店铺、CATEGORY：类目、ITEM：商品）,全平台默认不传")
    private String itemRange;

    @ApiModelProperty(name = "collectionMethod", value = "领取方式：1公开领取，2人工发放")
    private Integer collectionMethod;

    @ApiModelProperty(name = "forPepole", value = "适用人群：1全部，2指定身份")
    private Integer forPeople;

    @ApiModelProperty(name = "limitNum", value = "每人限制领取总数")
    @Range(min = 1, max = 10000000)
    private Integer limitNum;

    @ApiModelProperty(name = "dailyLimitNum", value = "每人每天限制领取总数")
    @Range(min = 1, max = 10000000)
    private Integer dailyLimitNum;

    @ApiModelProperty(name = "receiveStartTime", value = "领取开始时间")
    private Date receiveStartTime;

    @ApiModelProperty(name = "receiveEndTime", value = "领取截止时间")
    private Date receiveEndTime;

    @ApiModelProperty(name = "shopIdList", value = "适用的店铺id列表，适用范围为店铺时候填写")
    private List<Long> shopIdList;

    @ApiModelProperty(name = "dirIdList", value = "适用的类目id列表，适用范围为品类时填写")
    private List<Long> dirIdList;

    @ApiModelProperty(name = "couponItems", value = "优惠券商品列表")
    private List<CouponItemDto> couponItems;

    @ApiModelProperty(name = "brandIdList", value = "适用的品牌id列表，适用范围为品类时填写")
    private List<Long> brandIdList;

    @ApiModelProperty(name = "itemIdList", value = "适用的商品id列表，适用范围为商品时填写")
    @Deprecated
    private List<Long> itemIdList;

    @ApiModelProperty(name = "couponTemplateStatus", value = "优惠券模板状态:10=已创建, 20=已激活, 30=已停用, 40=已作废, " +
            "待审核WAIT_AUDIT，未激活NOT_ACTIVATE,审核不通过AUDIT_REFUSE")
    private String couponTemplateStatus;

    @ApiModelProperty(name = "tag", value = "活动标签")
    private String tag;

    @ApiModelProperty(name = "sendPoint", value = "公开领取需要消耗的积分")
    private Integer sendPoint;

    @ApiModelProperty(name = "exchangeItems", value = "兑换商品列表")
    private List<CouponItemDto> exchangeItems;

    /**
     * 有效期类型,-1 永久可用，1固定日期，2动态时期
     */
    @ApiModelProperty(name = "validityType", value = "有效期类型:1固定日期，2动态时期")
    private Integer validityType;

    /**
     * 动态日期配置{"afterDate":"1","day":"2"}
     */
    @ApiModelProperty(name = "dynamicDate", value = "动态日期配置{\"afterDate\":\"1\",\"day\":\"2\"}")
    private String dynamicDate;


    @ApiModelProperty(name = "eventMarketingNum", value = "事件营销赠送送优惠券数量")
    private Integer eventMarketingNum;

    @ApiModelProperty(name = "couponRanges", value = "券范围类型10=平台券，20=店铺券，多个逗号隔开")
    private String couponRanges;

    public String getCouponCode() {
        return couponCode;
    }

    public void setCouponCode(String couponCode) {
        this.couponCode = couponCode;
    }

    public String getCouponName() {
        return couponName;
    }

    public void setCouponName(String couponName) {
        this.couponName = couponName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public BigDecimal getCouponValue() {
        return couponValue;
    }

    public void setCouponValue(BigDecimal couponValue) {
        this.couponValue = couponValue;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public Long getTotalIssueQuantity() {
        return totalIssueQuantity;
    }

    public void setTotalIssueQuantity(Long totalIssueQuantity) {
        this.totalIssueQuantity = totalIssueQuantity;
    }

    public Date getCouponUseBeginTime() {
        return couponUseBeginTime;
    }

    public void setCouponUseBeginTime(Date couponUseBeginTime) {
        this.couponUseBeginTime = couponUseBeginTime;
    }

    public Date getCouponUseEndTime() {
        return couponUseEndTime;
    }

    public void setCouponUseEndTime(Date couponUseEndTime) {
        this.couponUseEndTime = couponUseEndTime;
    }

    public String getItemRange() {
        return itemRange;
    }

    public void setItemRange(String itemRange) {
        this.itemRange = itemRange;
    }

    public Integer getCollectionMethod() {
        return collectionMethod;
    }

    public void setCollectionMethod(Integer collectionMethod) {
        this.collectionMethod = collectionMethod;
    }

    public Integer getForPeople() {
        return forPeople;
    }

    public void setForPeople(Integer forPeople) {
        this.forPeople = forPeople;
    }

    public Integer getLimitNum() {
        return limitNum;
    }

    public void setLimitNum(Integer limitNum) {
        this.limitNum = limitNum;
    }

    public Integer getDailyLimitNum() {
        return dailyLimitNum;
    }

    public void setDailyLimitNum(Integer dailyLimitNum) {
        this.dailyLimitNum = dailyLimitNum;
    }

    public Date getReceiveStartTime() {
        return receiveStartTime;
    }

    public void setReceiveStartTime(Date receiveStartTime) {
        this.receiveStartTime = receiveStartTime;
    }

    public Date getReceiveEndTime() {
        return receiveEndTime;
    }

    public void setReceiveEndTime(Date receiveEndTime) {
        this.receiveEndTime = receiveEndTime;
    }

    public List<Long> getShopIdList() {
        return shopIdList;
    }

    public void setShopIdList(List<Long> shopIdList) {
        this.shopIdList = shopIdList;
    }

    public List<Long> getDirIdList() {
        return dirIdList;
    }

    public void setDirIdList(List<Long> dirIdList) {
        this.dirIdList = dirIdList;
    }

    public List<Long> getBrandIdList() {
        return brandIdList;
    }

    public void setBrandIdList(List<Long> brandIdList) {
        this.brandIdList = brandIdList;
    }

    public List<Long> getItemIdList() {
        return itemIdList;
    }

    public void setItemIdList(List<Long> itemIdList) {
        this.itemIdList = itemIdList;
    }

    public String getCouponTemplateStatus() {
        return couponTemplateStatus;
    }

    public void setCouponTemplateStatus(String couponTemplateStatus) {
        this.couponTemplateStatus = couponTemplateStatus;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getCouponRange() {
        return couponRange;
    }

    public void setCouponRange(Integer couponRange) {
        this.couponRange = couponRange;
    }

    public Integer getCouponCategory() {
        return couponCategory;
    }

    public void setCouponCategory(Integer couponCategory) {
        this.couponCategory = couponCategory;
    }

    public List<Integer> getSharedDiscountList() {
        return sharedDiscountList;
    }

    public void setSharedDiscountList(List<Integer> sharedDiscountList) {
        this.sharedDiscountList = sharedDiscountList;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getTag() {
        return tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public List<CouponItemDto> getCouponItems() {
        return couponItems;
    }

    public void setCouponItems(List<CouponItemDto> couponItems) {
        this.couponItems = couponItems;
    }

    public Integer getSendPoint() {
        return sendPoint;
    }

    public void setSendPoint(Integer sendPoint) {
        this.sendPoint = sendPoint;
    }

    public List<CouponItemDto> getExchangeItems() {
        return exchangeItems;
    }

    public void setExchangeItems(List<CouponItemDto> exchangeItems) {
        this.exchangeItems = exchangeItems;
    }

    public CouponUseTimeDto getCouponUseTimeReqDto() {
        return couponUseTimeReqDto;
    }

    public void setCouponUseTimeReqDto(CouponUseTimeDto couponUseTimeDto) {
        this.couponUseTimeReqDto = couponUseTimeDto;
    }

    public Byte getCouponUseTimeType() {
        return couponUseTimeType;
    }

    public void setCouponUseTimeType(Byte couponUseTimeType) {
        this.couponUseTimeType = couponUseTimeType;
    }

    public String getCouponUseTimeValue() {
        return couponUseTimeValue;
    }

    public void setCouponUseTimeValue(String couponUseTimeValue) {
        this.couponUseTimeValue = couponUseTimeValue;
    }

    public Integer getValidityType() {
        return validityType;
    }

    public void setValidityType(Integer validityType) {
        this.validityType = validityType;
    }

    public String getDynamicDate() {
        return dynamicDate;
    }

    public void setDynamicDate(String dynamicDate) {
        this.dynamicDate = dynamicDate;
    }

    public Integer getEventMarketingNum() {
        return eventMarketingNum;
    }

    public void setEventMarketingNum(Integer eventMarketingNum) {
        this.eventMarketingNum = eventMarketingNum;
    }

    public String getCouponRanges() {
        return couponRanges;
    }

    public void setCouponRanges(String couponRanges) {
        this.couponRanges = couponRanges;
    }
}
