/**
 * @(#)CouponUseTimeReqDto.java 1.0 2020-12-21
 * Copyright(c)2020,YUNXI.All rights reserved.
 * YUNXIPROPRIETARY/CONFIDENTIAL.Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.common;

import cn.hutool.core.date.DatePattern;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.util.DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 优惠券使用时间定义
 *
 * @author 本参
 * @since 3.11.1
 */
@ApiModel(value = "CouponUseTimeReqDto", description = "优惠券使用时间定义")
public class CouponUseTimeDto {

    public static final String START_TIME = "couponUseBeginTime";
    public static final String END_TIME = "couponUseEndTime";

    /**
     * 优惠券的使用时间类型
     * 0 时间范围（默认）
     * 1 当日起N天内有效 自然日
     * 2 次日起N天内有效 自然日
     * 3 永久有效
     */
    @ApiModelProperty(name = "type", value = "优惠券的使用时间类型:<br/>0 时间范围（默认）;1 当日起N天内有效 自然日;2 次日起N天内有效 自然日;3 永久有效;")
    @NotNull(message = "时间范围定义不可以为空")
    private Integer type = 0;


    @ApiModelProperty(name = "value", value = "根据type的不同而变化 当type=0时候 {\"couponUseBeginTime\":\"yyyy-MM-dd HH:mm:ss\"},当type=1或2的时候:该值为大于0整型数，当type=3时 该值默认为0")
    private Object value = null;

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Object getValue() {
        return value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setFixDate(Date beginTime, Date endTime) {
        this.setType(0);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(START_TIME, DateUtil.format(beginTime,DatePattern.NORM_DATETIME_PATTERN));
        jsonObject.put(END_TIME, DateUtil.format(endTime,DatePattern.NORM_DATETIME_PATTERN));
        this.setValue(jsonObject);
    }
}
