/**
 * @(#)PromotionActivityItem.java 1.0 2020/4/29
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

/**
 * 促销活动商品
 *
 * @author wu.sheng
 * @date 2020/4/29 16:20
 */
@ApiModel(value = "PromotionActivityItemDto", description = "促销活动商品dto")
public class PromotionActivityItemDto {

    @ApiModelProperty(name = "id", value = "商品id")
    private Long id;

    @ApiModelProperty(name = "itemId", value = "商品id")
    private Long itemId;

    @ApiModelProperty(name = "itemCode", value = "编码")
    private String itemCode;

    @ApiModelProperty(name = "itemName", value = "名称")
    private String itemName;

    @ApiModelProperty(name = "sellPrice", value = "售价")
    private BigDecimal sellPrice;

    @ApiModelProperty(name = "totalStock", value = "可用库存")
    private Long totalStock;

    @ApiModelProperty(name = "sellerId", value = "商户ID")
    private Long sellerId;

    @ApiModelProperty(name = "skus", value = "促销活动商品SKU")
    private List<PromotionActivitySkuDto> skus;

    @ApiModelProperty(name = "purchaseQuantityLimitSingle", value = "单次购买数量限制")
    private Integer purchaseQuantityLimitSingle;

    @ApiModelProperty(name = "shopId", value = "店铺id")
    @NotNull(message = "商品店铺id不能为空")
    private Long shopId;

    @ApiModelProperty(name = "shopName", value = "店铺名称")
    private String shopName;

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public BigDecimal getSellPrice() {
        return sellPrice;
    }

    public void setSellPrice(BigDecimal sellPrice) {
        this.sellPrice = sellPrice;
    }

    public Long getTotalStock() {
        return totalStock;
    }

    public void setTotalStock(Long totalStock) {
        this.totalStock = totalStock;
    }

    public List<PromotionActivitySkuDto> getSkus() {
        return skus;
    }

    public void setSkus(List<PromotionActivitySkuDto> skus) {
        this.skus = skus;
    }
    public Long getSellerId() {
        return sellerId;
    }
    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public String getShopName() {
        return shopName;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getPurchaseQuantityLimitSingle() {
        return purchaseQuantityLimitSingle;
    }

    public void setPurchaseQuantityLimitSingle(Integer purchaseQuantityLimitSingle) {
        this.purchaseQuantityLimitSingle = purchaseQuantityLimitSingle;
    }
}
