/**
 * @(#)PromotionActivitySkuDto.java 1.0 2020/4/29
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * 促销活动商品sku
 *
 * @author wu.sheng
 * @date 2020/4/29 16:19
 */
@ApiModel(value = "PromotionActivitySkuDto", description = "促销活动商品SKU dto")
public class PromotionActivitySkuDto {

    @ApiModelProperty(name = "skuId", value = "规格id")
    @NotNull
    private Long skuId;

    @ApiModelProperty(name = "itemId", value = "商品id")
    @NotNull
    private Long itemId;

    @ApiModelProperty(name = "skuName", value = "规格名称")
    private String skuName;

    @ApiModelProperty(name = "sellPrice", value = "售价")
    private BigDecimal sellPrice;

    @ApiModelProperty(name = "stock", value = "可用库存")
    private Long stock;

    @ApiModelProperty(name = "promotionPrice", value = "促销价格")
    @NotNull
    private BigDecimal promotionPrice;

    @ApiModelProperty(name = "discount", value = "折扣", example = "9.55")
    private BigDecimal discount;

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public BigDecimal getSellPrice() {
        return sellPrice;
    }

    public void setSellPrice(BigDecimal sellPrice) {
        this.sellPrice = sellPrice;
    }

    public Long getStock() {
        return stock;
    }

    public void setStock(Long stock) {
        this.stock = stock;
    }

    public BigDecimal getPromotionPrice() {
        return promotionPrice;
    }

    public void setPromotionPrice(BigDecimal promotionPrice) {
        this.promotionPrice = promotionPrice;
    }

    public BigDecimal getDiscount() {
        return discount;
    }

    public void setDiscount(BigDecimal discount) {
        this.discount = discount;
    }
}
