/*
 * @(#)BrandRespDto.java 1.0 2018-09-02
 *
 * 			Copyright (c) 2017, YUNXI. All rights reserved.
 * 			YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.coupon;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;

/**
 * 品牌响应Dto
 *
 * @author 风影
 * @since 2.0.0
 */
@ApiModel(value = "CouponBrandRespDto", description = "品牌响应Dto")
public class CouponBrandRespDto extends BaseRespDto {

    /**
     * 主键ID
     */
    @ApiModelProperty(name = "id", value = "主键ID")
    private Long id;
    /**
     * 品牌商id
     */
    @ApiModelProperty(name = "code", value = "品牌商id")
    private String code;
    /**
     * 品牌商名称
     */
    @ApiModelProperty(name = "name", value = "品牌名称")
    private String name;
    /**
     * 多媒体url
     */
    @ApiModelProperty(name = "logoUrl", value = "多媒体url")
    private String logoUrl;
    /**
     * 官方地址
     */
    @ApiModelProperty(name = "homePageUrl", value = "官方地址")
    private String homePageUrl;
    /**
     * 状态 0 禁用 1 启用
     */
    @ApiModelProperty(name = "status", value = "状态 0 禁用 1 启用")
    private Integer status;
    /**
     * 品牌简述
     */
    @Column(name = "brief")
    @ApiModelProperty(name = "brief", value = "品牌简述")
    private String brief;
    /**
     * 创建人
     */
    @ApiModelProperty(name = "ownerId", value = "创建人")
    private Long ownerId;
    /**
     * 品牌详情
     */
    @Column(name = "detail")
    @ApiModelProperty(name = "detail", value = "品牌商详情")
    private String detail;
    /**
     * 租户id
     */
    @ApiModelProperty(name = "instanceId", value = "租户id")
    private Long instanceId;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLogoUrl() {
        return logoUrl;
    }

    public void setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
    }

    public String getHomePageUrl() {
        return homePageUrl;
    }

    public void setHomePageUrl(String homePageUrl) {
        this.homePageUrl = homePageUrl;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getBrief() {
        return brief;
    }

    public void setBrief(String brief) {
        this.brief = brief;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Long getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }

    public String getDetail() {
        return detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }
}
