/**
 * @(#)CouponCalculateReqDto.java 1.0 2019/11/28
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.coupon;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.util.List;


@ApiModel(value = "CouponCalculateReqDto", description = "优惠券金额计算")
public class CouponCalculateReqDto {

    @ApiModelProperty(name = "itemList", value = "优惠券商品信息")
    @Valid
    List<OrderItemReqDto> itemList;

    @ApiModelProperty(name = "couponId", value = "优惠券id")
    @NotNull
    private Long couponId;

    public List<OrderItemReqDto> getItemList() {
        return itemList;
    }

    public void setItemList(List<OrderItemReqDto> itemList) {
        this.itemList = itemList;
    }

    public Long getCouponId() {
        return couponId;
    }

    public void setCouponId(Long couponId) {
        this.couponId = couponId;
    }
}
