/**
 * @(#)GrantCouponReqDto.java 1.0 2019/11/19
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.coupon;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 优惠券发放参数
 *
 * @author wu.sheng
 * @date 2019/11/19 16:03
 */
@ApiModel(value = "CouponGrantReqDto", description = "优惠券发放参数")
public class CouponGrantReqDto {


    @ApiModelProperty(name = "templateId", value = "优惠券模板id")
    @NotNull
    private Long templateId;

    @ApiModelProperty(name = "grantNum", value = "发放数量")
    @NotNull
    private Integer grantNum;

    @ApiModelProperty(name = "memberIdList", value = "会员id列表")
    private List<Long> memberIdList;

    public Integer getGrantNum() {
        return grantNum;
    }

    public void setGrantNum(Integer grantNum) {
        this.grantNum = grantNum;
    }

    public List<Long> getMemberIdList() {
        return memberIdList;
    }

    public void setMemberIdList(List<Long> memberIdList) {
        this.memberIdList = memberIdList;
    }

    public Long getTemplateId() {
        return templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }
}
