/**
 * @(#)CouponQueryReqDto.java 1.0 2019/12/27
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.coupon;


import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 优惠券领取记录查询参数
 *
 * @author wu.sheng
 * @date 2019/12/27 15:00
 */
@ApiModel(value = "CouponReceiveRecordReqDto", description = "优惠券领取记录查询参数")
public class CouponReceiveRecordReqDto extends CouponReqDto {

    @ApiModelProperty(name = "receiveTimeBegin", value = "领取时间开始区间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date receiveTimeBegin;

    @ApiModelProperty(name = "receiveTimeEnd", value = "领取时间结束区间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date receiveTimeEnd;

    @Override
    public Date getReceiveTimeBegin() {
        return receiveTimeBegin;
    }

    @Override
    public void setReceiveTimeBegin(Date receiveTimeBegin) {
        this.receiveTimeBegin = receiveTimeBegin;
    }

    @Override
    public Date getReceiveTimeEnd() {
        return receiveTimeEnd;
    }

    @Override
    public void setReceiveTimeEnd(Date receiveTimeEnd) {
        this.receiveTimeEnd = receiveTimeEnd;
    }
}
