/**
 * @(#)MatchCouponReqDto.java 1.0 2019/11/26
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.coupon;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

/**
 * 下单匹配可用优惠券参数
 *
 * @author wu.sheng
 * @date 2019/11/26 15:39
 */
@ApiModel(value = "MatchCouponReqDto", description = "下单匹配可用优惠券参数")
public class MatchCouponReqDto {

    @ApiModelProperty(name = "totalAmount", value = "订单金额")
    @NotNull
    private BigDecimal totalAmount;

    @ApiModelProperty(name = "couponRange", value = "优惠券类型：10=平台券，20=店铺券")
    @NotNull
    private Integer couponRange;

    @ApiModelProperty(name = "itemList", value = "商品列表")
    @NotNull
    List<OrderItemReqDto> itemList;

    @ApiModelProperty(name = "shopId", value = "前端分组显示传入,无实际意义")
    private Long shopId;

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public Integer getCouponRange() {
        return couponRange;
    }

    public void setCouponRange(Integer couponRange) {
        this.couponRange = couponRange;
    }

    public List<OrderItemReqDto> getItemList() {
        return itemList;
    }

    public void setItemList(List<OrderItemReqDto> itemList) {
        this.itemList = itemList;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }
}
