/**
 * @(#)OrderItemDto.java 1.0 2019/10/25
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.coupon;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * 匹配可用优惠券商品参数
 *
 * @author wu.sheng
 * @date 2019/10/25 10:04
 */
@ApiModel(value = "OrderItemReqDto", description = "匹配可用优惠券商品参数")
public class OrderItemReqDto {

    @ApiModelProperty(name = "shopId", value = "店铺id")
    @NotNull
    private Long shopId;

    @ApiModelProperty(name = "itemId", value = "商品id")
    @NotNull
    private Long itemId;

    @ApiModelProperty(name = "skuId", value = "商品skuId")
    private Long skuId;

    @ApiModelProperty(name = "itemNum", value = "商品数量")
    @NotNull(message = "商品数量不能为空")
    private Integer itemNum;

    @ApiModelProperty(name = "sellPrice", value = "商品售价")
    @NotNull(message = "商品价格不能为空")
    private BigDecimal sellPrice;

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public Integer getItemNum() {
        return itemNum;
    }

    public void setItemNum(Integer itemNum) {
        this.itemNum = itemNum;
    }

    public BigDecimal getSellPrice() {
        return sellPrice;
    }

    public void setSellPrice(BigDecimal sellPrice) {
        this.sellPrice = sellPrice;
    }

}
