/**
 * @(#)ExchangeActivityDto.java 1.0 2021/7/28
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.exchange;

import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.common.BaseActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.PromotionActivityItemDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.model.ExcRuleContentDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 换购活动dto
 *
 * @author wu.sheng
 * @date 2021/7/28 14:18
 */
@ApiModel(value = "ExchangeActivityDto", description = "换购活动dto")
public class ExchangeActivityDto extends BaseActivityDto {

    @ApiModelProperty(name = "activityItems", value = "活动商品")
    private List<PromotionActivityItemDto> activityItems;

    @ApiModelProperty(name = "换购门槛", value = "0任意消费，1指定消费门槛")
    private Integer thresholdType;

    @ApiModelProperty(name = "promotionCondition", value = "促销条件： 1 阶梯")
    private Integer promotionCondition;

    @ApiModelProperty(name = "promotionContents", value = "促销内容条件")
    private List<ExcRuleContentDto> promotionContents;

    @ApiModelProperty(name = "joinNum", value = "每人参与次数(为空无限制)")
    private Integer joinNum;

    @ApiModelProperty(name = "itemLimit", value = "商品换购数量限制：1可换购一件，2可换购多件")
    private Integer itemLimit;

    public List<PromotionActivityItemDto> getActivityItems() {
        return activityItems;
    }

    public void setActivityItems(List<PromotionActivityItemDto> activityItems) {
        this.activityItems = activityItems;
    }

    public Integer getThresholdType() {
        return thresholdType;
    }

    public void setThresholdType(Integer thresholdType) {
        this.thresholdType = thresholdType;
    }

    public Integer getPromotionCondition() {
        return promotionCondition;
    }

    public void setPromotionCondition(Integer promotionCondition) {
        this.promotionCondition = promotionCondition;
    }

    public List<ExcRuleContentDto> getPromotionContents() {
        return promotionContents;
    }

    public void setPromotionContents(List<ExcRuleContentDto> promotionContents) {
        this.promotionContents = promotionContents;
    }

    public Integer getJoinNum() {
        return joinNum;
    }

    public void setJoinNum(Integer joinNum) {
        this.joinNum = joinNum;
    }

    public Integer getItemLimit() {
        return itemLimit;
    }

    public void setItemLimit(Integer itemLimit) {
        this.itemLimit = itemLimit;
    }
}
