package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.fullreduction;

import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.common.PromotionActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.PromotionActivityItemDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * File                 : FullReductionActivityDto
 * Copy Right           : 广州云徙科技有限公司
 * Project              : yundt-module-marketing
 * JDK version used     : JDK 1.8
 * Comments             : 满减满折活动
 * Version              : 1.00
 * Modification history : 2020/4/29 17:47 [created]
 * Author               : 东海|颜海东
 * Email                : donghai.yhd@dtyunxi.com
 */
@ApiModel(value = "FullReductionActivityDto", description = "满减满折活动dto")
public class FullReductionActivityDto extends PromotionActivityDto {

	@ApiModelProperty(name = "selectType", value = "使用商品：0全部，1部分")
	private Integer  selectType;

	@ApiModelProperty(name = "activityItems", value = "活动商品")
	private List<PromotionActivityItemDto> activityItems;

	@ApiModelProperty(name = "promotionType", value = "促销类别：1 满减，2 满折")
	private Integer promotionType;

	@ApiModelProperty(name = "promotionCondition", value = "促销条件： 1 阶梯，2 每满，3 满")
	private Integer promotionCondition;

	@ApiModelProperty(name = "promotionContents", value = "促销内容条件")
	private List<FullDecRuleContent> promotionContents;

	public Integer getSelectType() {
		return selectType;
	}
	public void setSelectType(Integer selectType) {
		this.selectType = selectType;
	}
	public List<PromotionActivityItemDto> getActivityItems() {
		return activityItems;
	}
	public void setActivityItems(List<PromotionActivityItemDto> activityItems) {
		this.activityItems = activityItems;
	}

	public Integer getPromotionType() {
		return promotionType;
	}

	public void setPromotionType(Integer promotionType) {
		this.promotionType = promotionType;
	}

	public Integer getPromotionCondition() {
		return promotionCondition;
	}

	public void setPromotionCondition(Integer promotionCondition) {
		this.promotionCondition = promotionCondition;
	}

	public List<FullDecRuleContent> getPromotionContents() {
		return promotionContents;
	}

	public void setPromotionContents(List<FullDecRuleContent> promotionContents) {
		this.promotionContents = promotionContents;
	}
}
