/**
 * @(#)GroupActivityReqDto.java 1.0 2020/4/10
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.group;


import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 拼团活动请求dto
 *
 * @author wu.sheng
 * @date 2020/4/10 10:40
 */
@ApiModel(value = "GroupActivityQueryReqDto", description = "拼团活动请求dto")
public class ActivityQueryReqDto {

    @ApiModelProperty(name = "activityName", value = "活动名称")
    private String activityName;

    @ApiModelProperty(name = "activityTimeStart", value = "活动时间起", example = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date activityTimeStart;

    @ApiModelProperty(name = "activityTimeEnd", value = "活动时间止", example = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date activityTimeEnd;

    @ApiModelProperty(name = "activityStatus", value = "活动状态：未开始READY，进行中ACTIVATE，已结束FINISH, 待审核WAIT_AUDIT，审核不通过AUDIT_REFUSE")
    private String activityStatus;

    @ApiModelProperty(name = "activityType", required = true, value = "活动类型: 拼团活动GROUP_ACTIVITYPE," +
            "限时折扣TIME_DISCOUNT_ACTIVITY，满折满减FULL_REDUCTION_ACTIVITY，满返FULL_RETURNING_ACTIVITY，满赠FULL_PRESENT_ACTIVITY")
    private ActivityType activityType;

    public String getActivityName() {
        return activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public Date getActivityTimeStart() {
        return activityTimeStart;
    }

    public void setActivityTimeStart(Date activityTimeStart) {
        this.activityTimeStart = activityTimeStart;
    }

    public Date getActivityTimeEnd() {
        return activityTimeEnd;
    }

    public void setActivityTimeEnd(Date activityTimeEnd) {
        this.activityTimeEnd = activityTimeEnd;
    }

    public String getActivityStatus() {
        return activityStatus;
    }

    public void setActivityStatus(String activityStatus) {
        this.activityStatus = activityStatus;
    }

    public ActivityType getActivityType() {
        return activityType;
    }

    public void setActivityType(ActivityType activityType) {
        this.activityType = activityType;
    }
}
