/**
 * @(#)GroupActivityReqDto.java 1.0 2020/4/10
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.group;


import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.common.BaseActivityDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

/**
 * 拼团活动请求dto
 *
 * @author wu.sheng
 * @date 2020/4/10 10:40
 */
@ApiModel(value = "GroupActivityDto", description = "拼团活动请求dto")
@Validated
public class GroupActivityDto extends BaseActivityDto {

    public GroupActivityDto() {
    }

    public GroupActivityDto(ActivityRespDto activityDto) {
        super(activityDto);
    }

    @ApiModelProperty(name = "groupNumber", value = "拼团人数限制")
    @NotNull
    private Integer groupNumber;

    @ApiModelProperty(name = "overNumberShow", value = "超过人数需新开团:true显示，false不显示")
    private Boolean overNumberShow;

    @ApiModelProperty(name = "groupEffectiveTime", value = "拼团有效期（单位：分钟）")
    @NotNull
    private Integer groupEffectiveTime;

    @ApiModelProperty(name = "items", value = "活动商品")
    @NotNull
    private List<GroupActivityItemDto> items;

    @ApiModelProperty(name = "totalGroupNumber", value = "活动累计参与拼团人数")
    private Long totalGroupNumber;

    @ApiModelProperty(name = "orderAmount", value = "活动累计实付订单金额")
    private BigDecimal orderAmount;

    public Boolean getOverNumberShow() {
        return overNumberShow;
    }

    public void setOverNumberShow(Boolean overNumberShow) {
        this.overNumberShow = overNumberShow;
    }

    public Integer getGroupEffectiveTime() {
        return groupEffectiveTime;
    }

    public void setGroupEffectiveTime(Integer groupEffectiveTime) {
        this.groupEffectiveTime = groupEffectiveTime;
    }

    public List<GroupActivityItemDto> getItems() {
        return items;
    }

    public void setItems(List<GroupActivityItemDto> items) {
        this.items = items;
    }

    public Integer getGroupNumber() {
        return groupNumber;
    }

    public void setGroupNumber(Integer groupNumber) {
        this.groupNumber = groupNumber;
    }

    public Long getTotalGroupNumber() {
        return totalGroupNumber;
    }

    public void setTotalGroupNumber(Long totalGroupNumber) {
        this.totalGroupNumber = totalGroupNumber;
    }

    public BigDecimal getOrderAmount() {
        return orderAmount;
    }

    public void setOrderAmount(BigDecimal orderAmount) {
        this.orderAmount = orderAmount;
    }
}
