/**
 * @(#)GroupActivityReqDto.java 1.0 2020/4/10
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.group;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

/**
 * 拼团活动商品dto
 *
 * @author wu.sheng
 * @date 2020/4/10 10:40
 */
@ApiModel(value = "GroupActivityItemDto", description = "拼团活动商品请求dto")
@Validated
public class GroupActivityItemDto {

    private Long id;

    @ApiModelProperty(name = "itemId", value = "商品id")
    @NotNull
    private Long itemId;

    @ApiModelProperty(name = "itemCode", value = "商品编码")
    private String itemCode;

    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;

    @ApiModelProperty(name = "sellPrice", value = "商品价格")
    private BigDecimal sellPrice;

    @ApiModelProperty(name = "totalStock", value = "商品可用库存")
    private Long totalStock;

    @ApiModelProperty(name = "purchaseQuantityLimit",       value = "总购买数量限制")
    private Integer purchaseQuantityLimit;

    @ApiModelProperty(name = "purchaseQuantityLimitSingle", value = "单次购买数量限制")
    private Integer purchaseQuantityLimitSingle;

    @ApiModelProperty(name = "skus", value = "商品规格")
    List<GroupActivityItemSkuDto> skus;

    @ApiModelProperty(name = "shopId", value = "店铺id")
    private Long shopId;

    @ApiModelProperty(name = "shopName", value = "店铺名称")
    private String shopName;

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public BigDecimal getSellPrice() {
        return sellPrice;
    }

    public void setSellPrice(BigDecimal sellPrice) {
        this.sellPrice = sellPrice;
    }

    public Long getTotalStock() {
        return totalStock;
    }

    public void setTotalStock(Long totalStock) {
        this.totalStock = totalStock;
    }

    public List<GroupActivityItemSkuDto> getSkus() {
        return skus;
    }

    public void setSkus(List<GroupActivityItemSkuDto> skus) {
        this.skus = skus;
    }

    public Integer getPurchaseQuantityLimit() {
        return purchaseQuantityLimit;
    }

    public void setPurchaseQuantityLimit(Integer purchaseQuantityLimit) {
        this.purchaseQuantityLimit = purchaseQuantityLimit;
    }

    public Integer getPurchaseQuantityLimitSingle() {
        return purchaseQuantityLimitSingle;
    }
    public void setPurchaseQuantityLimitSingle(Integer purchaseQuantityLimitSingle) {
        this.purchaseQuantityLimitSingle = purchaseQuantityLimitSingle;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public String getShopName() {
        return shopName;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }
}
