/**
 * @(#)FullDecContent.java 1.0 2020/5/7
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.returngift;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 促销内容条件明细
 *
 * @author 伊泽
 * @since 1.0.0
 */
@ApiModel(value = "FullDecRuleContent", description = "促销内容条件明细")
public class ReturnGiftRuleContent {

    /**
     * 促销条件数量
     */
    @ApiModelProperty(name = "threshold", value = "促销条件数量")
    private BigDecimal threshold;

    /**
     * 单位: 1 元，2 件
     */
    @ApiModelProperty(name = "unit", value = "单位: 1 元，2 件")
    private Integer unit;

    /**
     * 优惠额度
     */
    @ApiModelProperty(name = "discount", value = "优惠额度")
    private BigDecimal discount;

    /**
     * 赠送优惠券
     */
    @ApiModelProperty(name = "coupons", value = "赠送优惠券")
    private Map<Long, Integer> coupons;

    /**
     * 赠送商品
     */
    @ApiModelProperty(name = "giftItems", value = "满赠商品")
    private List<GItem> giftItems;
    /**
     * 返积分数量
     */
    @ApiModelProperty(name = "points", value = "满返积分数量")
    private BigDecimal points;

    /**
     * 是否包邮
     */
    @ApiModelProperty(name = "isPostage", value = "是否包邮")
    private Boolean isPostage = false;

    public BigDecimal getThreshold() {
        return threshold;
    }

    public void setThreshold(BigDecimal threshold) {
        this.threshold = threshold;
    }

    public Integer getUnit() {
        return unit;
    }

    public void setUnit(Integer unit) {
        this.unit = unit;
    }

    public BigDecimal getDiscount() {
        return discount;
    }

    public void setDiscount(BigDecimal discount) {
        this.discount = discount;
    }

    public Map<Long, Integer> getCoupons() {
        return coupons;
    }

    public void setCoupons(Map<Long, Integer> coupons) {
        this.coupons = coupons;
    }

    public Boolean getPostage() {
        return isPostage;
    }

    public void setPostage(Boolean postage) {
        isPostage = postage;
    }

    public List<GItem> getGiftItems() {
        return giftItems;
    }

    public void setGiftItems(List<GItem> giftItems) {
        this.giftItems = giftItems;
    }

    public BigDecimal getPoints() {
        return points;
    }

    public void setPoints(BigDecimal points) {
        this.points = points;
    }
}
