/**
 * @(#)TimeDiscountActivityDto.java 1.0 2020/4/29
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.seckill;

import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.common.BaseActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.group.GroupActivityItemDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;

import javax.validation.constraints.NotEmpty;
import java.util.List;

/**
 * 秒杀活动dto
 *
 * @author wu.sheng
 * @date 2020/4/29 15:10
 */
@ApiModel(value = "SeckillActivityDto", description = "秒杀活动dto")
@Validated
public class SeckillActivityDto extends BaseActivityDto {

    @ApiModelProperty(name = "joinNum",     value = "每人参与次数(为空无限制)")
    private Integer  joinNum;
    @ApiModelProperty(name = "validPayTime", value = "有效支付时间(单位分钟)")
    private Integer validPayTime;
    @ApiModelProperty(name = "activityItems", value = "活动商品")

    @NotEmpty
    private List<GroupActivityItemDto> activityItems;

    public Integer getJoinNum() {
        return joinNum;
    }
    public void setJoinNum(Integer joinNum) {
        this.joinNum = joinNum;
    }
    public List<GroupActivityItemDto> getActivityItems() {
        return activityItems;
    }
    public void setActivityItems(List<GroupActivityItemDto> activityItems) {
        this.activityItems = activityItems;
    }
    public Integer getValidPayTime() {
        return validPayTime;
    }
    public void setValidPayTime(Integer validPayTime) {
        this.validPayTime = validPayTime;
    }
}
