/**
 * @(#)TimeDiscountActivityDto.java 1.0 2020/4/29
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.timediscount;

import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.common.PromotionActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.PromotionActivityItemDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 限时折扣活动
 *
 * @author wu.sheng
 * @date 2020/4/29 15:10
 */
@ApiModel(value = "TimeDiscountActivityDto", description = "限时折扣活动dto")
public class TimeDiscountActivityDto extends PromotionActivityDto {

    @ApiModelProperty(name = "promotionMethod", value = "促销方式：1促销价格，2折扣")
    private Integer promotionMethod;

    @ApiModelProperty(name = "activityItems", value = "活动商品")
    private List<PromotionActivityItemDto> activityItems;

    public Integer getPromotionMethod() {
        return promotionMethod;
    }

    public void setPromotionMethod(Integer promotionMethod) {
        this.promotionMethod = promotionMethod;
    }

    public List<PromotionActivityItemDto> getActivityItems() {
        return activityItems;
    }

    public void setActivityItems(List<PromotionActivityItemDto> activityItems) {
        this.activityItems = activityItems;
    }
}
