/**
 * @(#)ActivityGroupListRespDto.java 1.0 2020/4/15
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.response;


import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.crowdordering.dto.response.ActivityGroupRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * 拼团队伍列表查询响应dto
 *
 * @author wu.sheng
 * @date 2020/4/15 9:31
 */
@ApiModel(value = "ActivityGroupListRespDto", description = "拼团队伍列表查询响应dto")
public class ActivityGroupListRespDto extends ActivityGroupRespDto {

    @ApiModelProperty(name = "orderAmount", value = "订单总金额")
    private BigDecimal totalOrderAmount;

    @ApiModelProperty(name = "totalGroupNumber", value = "成团人数")
    private Integer totalGroupNumber;

    @ApiModelProperty(name = "avatar", value = "团长头像")
    private String avatar;

    @ApiModelProperty(name = "personName", value = "成员昵称")
    private String personName;

    public BigDecimal getTotalOrderAmount() {
        return totalOrderAmount;
    }

    public void setTotalOrderAmount(BigDecimal totalOrderAmount) {
        this.totalOrderAmount = totalOrderAmount;
    }

    public Integer getTotalGroupNumber() {
        return totalGroupNumber;
    }

    public void setTotalGroupNumber(Integer totalGroupNumber) {
        this.totalGroupNumber = totalGroupNumber;
    }

    public String getAvatar() {
        return avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public String getPersonName() {
        return personName;
    }

    public void setPersonName(String personName) {
        this.personName = personName;
    }
}
