/**
 * @(#)ActivityTermDetailRespDto.java 1.0 2020/4/16
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.response;


import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.crowdordering.dto.response.ActivityGroupDetailRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * @author 伊泽
 * @since 1.0.0
 */
@ApiModel(value = "ActivityTermDetailRespDto", description = "拼团队伍响应dto")
public class ActivityTermDetailRespDto{

    @ApiModelProperty(value = "队伍成员分页信息")
    PageInfo<ActivityGroupDetailRespDto> pageInfo;

    @ApiModelProperty(name = "successTime", value = "成团情况，即还差多少人满足成团条件")
    private Integer groupLackNum;

    @ApiModelProperty(name = "groupStatus", value = "团状态： 0 - 进行中 ,1 -成功 .2-失败")
    private Integer groupStatus;
    @ApiModelProperty(name = "groupNumber", value = "成团人数")

    private Integer groupNumber;
    @ApiModelProperty(name = "joinGroupNumber", value = "参团人数")
    private Integer joinGroupNumber;

    @ApiModelProperty(name = "closeTime", value = "团剩余时间(单位：毫秒)")
    private long remainTime;
    @ApiModelProperty(name = "successTime", value = "拼团成功时间")
    private Date successTime;

    @ApiModelProperty(name = "joinFlag", value = "当前账号参团标识")
    private Boolean joinFlag;

    public Date getSuccessTime() {
        return successTime;
    }

    public void setSuccessTime(Date successTime) {
        this.successTime = successTime;
    }

    public PageInfo<ActivityGroupDetailRespDto> getPageInfo() {
        return pageInfo;
    }

    public Integer getGroupNumber() {
        return groupNumber;
    }

    public void setGroupNumber(Integer groupNumber) {
        this.groupNumber = groupNumber;
    }

    public Integer getJoinGroupNumber() {
        return joinGroupNumber;
    }

    public void setJoinGroupNumber(Integer joinGroupNumber) {
        this.joinGroupNumber = joinGroupNumber;
    }

    public void setPageInfo(PageInfo<ActivityGroupDetailRespDto> pageInfo) {
        this.pageInfo = pageInfo;
    }

    public Integer getGroupLackNum() {
        return groupLackNum;
    }

    public void setGroupLackNum(Integer groupLackNum) {
        this.groupLackNum = groupLackNum;
    }

    public Integer getGroupStatus() {
        return groupStatus;
    }

    public void setGroupStatus(Integer groupStatus) {
        this.groupStatus = groupStatus;
    }

    public long getRemainTime() {
        return remainTime;
    }

    public void setRemainTime(long remainTime) {
        this.remainTime = remainTime;
    }

    public Boolean getJoinFlag() {
        return joinFlag;
    }

    public void setJoinFlag(Boolean joinFlag) {
        this.joinFlag = joinFlag;
    }
}
