/*
 * *
 *  * @(#)CouponInfoRespDto.java 2.0.0 4/14/20, 10:07 AM
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.response;


import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.common.BaseActivityDto;
import io.swagger.annotations.ApiModelProperty;

/**
 * 商品详情页 使用的优惠券信息
 *
 * @author luo.lei
 * @date 2020-04-14
 * @since 2.0.0
 */
public class CouponInfoRespDto extends BaseActivityDto {

    public CouponInfoRespDto() {
    }

    public CouponInfoRespDto(ActivityRespDto activityDto) {
        super(activityDto);
    }

    @ApiModelProperty(name = "couponRange", value = "券范围：10=平台券， 20=店铺券")
    private Integer couponRange;
    @ApiModelProperty(name = "couponValue", value = "面值（单位：元或百分比）")
    private String couponValue;
    @ApiModelProperty(name = "amount", value = "金额阈值，当达到该阈值，才能使用券")
    private String amount;

    @ApiModelProperty(name = "couponCategory", value = "券类别, 10=定额现金券（满减）, 50=满折券， 40=提货券")
    private int couponCategory;

    public Integer getCouponRange() {
        return couponRange;
    }

    public void setCouponRange(Integer couponRange) {
        this.couponRange = couponRange;
    }

    public String getCouponValue() {
        return couponValue;
    }

    public void setCouponValue(String couponValue) {
        this.couponValue = couponValue;
    }

    public String getAmount() {
        return amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public int getCouponCategory() {
        return couponCategory;
    }

    public void setCouponCategory(int couponCategory) {
        this.couponCategory = couponCategory;
    }
}
