/**
 * @(#)CouponRespDto.java 1.0 2019/11/20
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.response;

import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.common.CouponUseTimeDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 优惠券响应参数
 *
 * @author 伊泽
 * @since 1.0.0
 */
@ApiModel(value = "CouponRespDto", description = "优惠券响应参数")
public class CouponRespDto {

    @ApiModelProperty(name = "id", value = "优惠券id")
    private Long id;

    @ApiModelProperty(name = "couponName", value = "优惠券名称")
    private String couponName;

    @ApiModelProperty(name = "couponRange", value = "券范围类型：10=平台券，20=店铺券")
    private Integer couponRange;

    @ApiModelProperty(name = "couponValue", value = "面值（单位：元或百分比）")
    private BigDecimal couponValue;

    @ApiModelProperty(name = "amount", value = "优惠券金额阀值")
    private BigDecimal amount;

    @ApiModelProperty(name = "remark", value = "说明")
    private String remark;

    @ApiModelProperty(name = "couponCode", value = "券码")
    private String couponCode;

    @ApiModelProperty(name = "couponUseBeginTime", value = "优惠券使用开始时间")
    private Date couponUseBeginTime;

    @ApiModelProperty(name = "couponUseEndTime", value = "优惠券使用结束时间")
    private Date couponUseEndTime;

    @ApiModelProperty(name = "itemRange", value = "适用范围：SHOP：店铺、CATEGORY：类目、ITEM：商品")
    private String itemRange;

    @ApiModelProperty(name = "couponTemplateId", value = "优惠券模板id")
    private Long couponTemplateId;

    @ApiModelProperty(name = "couponCategory", value = "券类别, 10=定额现金券（满减）, 50=满折券， 40=提货券")
    private Integer couponCategory;

    @ApiModelProperty(name = "activityId", value = "活动id")
    private Long activityId;

    private CouponUseTimeDto couponUseTimeDto;

    @ApiModelProperty(name = "tag", value = "标签")
    private String tag;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCouponName() {
        return couponName;
    }

    public void setCouponName(String couponName) {
        this.couponName = couponName;
    }

    public Integer getCouponRange() {
        return couponRange;
    }

    public void setCouponRange(Integer couponRange) {
        this.couponRange = couponRange;
    }

    public BigDecimal getCouponValue() {
        return couponValue;
    }

    public void setCouponValue(BigDecimal couponValue) {
        this.couponValue = couponValue;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Date getCouponUseBeginTime() {
        return couponUseBeginTime;
    }

    public void setCouponUseBeginTime(Date couponUseBeginTime) {
        this.couponUseBeginTime = couponUseBeginTime;
    }

    public Date getCouponUseEndTime() {
        return couponUseEndTime;
    }

    public void setCouponUseEndTime(Date couponUseEndTime) {
        this.couponUseEndTime = couponUseEndTime;
    }

    public String getItemRange() {
        return itemRange;
    }

    public void setItemRange(String itemRange) {
        this.itemRange = itemRange;
    }

    public Long getCouponTemplateId() {
        return couponTemplateId;
    }

    public void setCouponTemplateId(Long couponTemplateId) {
        this.couponTemplateId = couponTemplateId;
    }

    public Integer getCouponCategory() {
        return couponCategory;
    }

    public void setCouponCategory(Integer couponCategory) {
        this.couponCategory = couponCategory;
    }

    public String getCouponCode() {
        return couponCode;
    }

    public void setCouponCode(String couponCode) {
        this.couponCode = couponCode;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public CouponUseTimeDto getCouponUseTimeDto() {
        return couponUseTimeDto;
    }

    public void setCouponUseTimeDto(CouponUseTimeDto couponUseTimeDto) {
        this.couponUseTimeDto = couponUseTimeDto;
    }

    public String getTag() {
        return tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }
}
