/**
 * @(#)CouponTemplateDetailRespDto.java 1.0 2019/11/20
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.response;


import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.common.CouponTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.coupon.CouponBrandRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.coupon.CouponDirRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.coupon.CouponShopBaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 模板详情
 *
 * @author wu.sheng
 * @date 2019/11/20 16:15
 */
@ApiModel(value = "CouponTemplateDetailRespDto", description = "模板详情返回参数")
public class CouponTemplateDetailRespDto extends CouponTemplate {

    @ApiModelProperty(name = "shopList", value = "适用的店铺列表")
    private List<CouponShopBaseDto> shopList;

    @ApiModelProperty(name = "dirList", value = "适用的类目列表")
    private List<CouponDirRespDto> dirList;

    @ApiModelProperty(name = "branList", value = "适用的品牌列表")
    private List<CouponBrandRespDto> brandList;

    @ApiModelProperty(name = "itemList", value = "适用的商品列表")
    private List<CouponItemRespDto> itemList;

    @ApiModelProperty(name = "remainingQuantity", value = "剩余库存数量")
    private Long remainingQuantity;

    @ApiModelProperty(name = "usedQuantity", value = "已使用数量")
    private Integer usedQuantity;

    @ApiModelProperty(name = "receivedQuantity", value = "已领取数量")
    private Integer receivedQuantity;

    public List<CouponShopBaseDto> getShopList() {
        return shopList;
    }

    public void setShopList(List<CouponShopBaseDto> shopList) {
        this.shopList = shopList;
    }

    public List<CouponDirRespDto> getDirList() {
        return dirList;
    }

    public void setDirList(List<CouponDirRespDto> dirList) {
        this.dirList = dirList;
    }

    public List<CouponBrandRespDto> getBrandList() {
        return brandList;
    }

    public void setBrandList(List<CouponBrandRespDto> brandList) {
        this.brandList = brandList;
    }

    public List<CouponItemRespDto> getItemList() {
        return itemList;
    }

    public void setItemList(List<CouponItemRespDto> itemList) {
        this.itemList = itemList;
    }

    public Long getRemainingQuantity() {
        return remainingQuantity;
    }

    public void setRemainingQuantity(Long remainingQuantity) {
        this.remainingQuantity = remainingQuantity;
    }

    public Integer getUsedQuantity() {
        return usedQuantity;
    }

    public void setUsedQuantity(Integer usedQuantity) {
        this.usedQuantity = usedQuantity;
    }

    public Integer getReceivedQuantity() {
        return receivedQuantity;
    }

    public void setReceivedQuantity(Integer receivedQuantity) {
        this.receivedQuantity = receivedQuantity;
    }
}
