/**
 * @(#)ExchangeItemRespDto.java 1.0 2020/11/12
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.response;

import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.coupon.CouponItemSkuDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Map;

/**
 * 兑换商品DTO
 *
 * @author wu.sheng
 * @date 2020/11/12 10:10
 */
@ApiModel(value = "ExchangeItemRespDto", description = "兑换商品DTO")
public class ExchangeItemRespDto  extends CouponItemSkuDto {

    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;

    @ApiModelProperty(name = "attrs", value = "规格属性")
    private Map<String, Object> attrs;

    @ApiModelProperty(name = "imgPath", value = "商品图片")
    private String imgPath;

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public Map<String, Object> getAttrs() {
        return attrs;
    }

    public void setAttrs(Map<String, Object> attrs) {
        this.attrs = attrs;
    }

    public String getImgPath() {
        return imgPath;
    }

    public void setImgPath(String imgPath) {
        this.imgPath = imgPath;
    }
}
