/**
 * @(#)ItemActivityInfoRespDto.java 1.0 2020/5/25
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.response;

import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.common.BaseActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.common.CouponTemplate;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 商品活动信息
 *
 * @author wu.sheng
 * @date 2020/5/25 15:41
 */
@ApiModel(value = "ItemActivityInfoRespDto", description = "商品活动信息响应dto")
public class ItemActivityInfoRespDto extends BaseActivityDto {

    @ApiModelProperty(name = "dimension", value = "活动维度：1商品维度，2订单维度，3券维度")
    private Integer dimension;

    @ApiModelProperty(name = "couponTemplate", value = "优惠券模板信息，券维度活动才会有值")
    private CouponTemplate couponTemplate;

    public Integer getDimension() {
        return dimension;
    }

    public void setDimension(Integer dimension) {
        this.dimension = dimension;
    }

    public CouponTemplate getCouponTemplate() {
        return couponTemplate;
    }

    public void setCouponTemplate(CouponTemplate couponTemplate) {
        this.couponTemplate = couponTemplate;
    }
}
