/*
 * *
 *  * @(#)ItemInfoActivityInfo.java 2.0.0 4/13/20, 4:38 PM
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.response;

import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.LinkedList;
import java.util.List;

/**
 * 商品详情页活动信息
 *
 * @author luo.lei
 * @date 2020-04-13
 * @since 2.0.0
 */
@ApiModel(value = "ItemForActivityInfoRespDto", description = "活动响应dto")
public class ItemForActivityInfoRespDto {

    @Deprecated
    private List<PromotionInfoRespDto> normalPromotions = new LinkedList<>();
    @Deprecated
    private List<CouponInfoRespDto> couponPromotions = new LinkedList<>();
    @Deprecated
    private List<GroupInfoRespDto> activityGroupPromotions = new LinkedList<>();
    /**
     * 服务器时间
     */
    private long systemTime;


    @ApiModelProperty(name = "itemActivityInfo", value = "商品维度活动")
    private List<ItemActivityInfoRespDto> itemActivityInfo = Lists.newArrayList();

    @ApiModelProperty(name = "orderActivityInfo", value = "订单维度活动")
    private List<ItemActivityInfoRespDto> orderActivityInfo = Lists.newArrayList();

    @ApiModelProperty(name = "couponActivityInfo", value = "券维度活动")
    private List<ItemActivityInfoRespDto> couponActivityInfo = Lists.newArrayList();

    public void addNormalPromotions(PromotionInfoRespDto p) {
        this.normalPromotions.add(p);
    }

    public void addCouponPromotions(CouponInfoRespDto p) {
        this.couponPromotions.add(p);
    }

    public void addActivityGroupPromotions(GroupInfoRespDto p) {
        this.activityGroupPromotions.add(p);
    }


    public List<PromotionInfoRespDto> getNormalPromotions() {
        return normalPromotions;
    }

    public List<CouponInfoRespDto> getCouponPromotions() {
        return couponPromotions;
    }

    public List<GroupInfoRespDto> getActivityGroupPromotions() {
        return activityGroupPromotions;
    }

    public long getSystemTime() {
        return systemTime;
    }

    public void setSystemTime(long systemTime) {
        this.systemTime = systemTime;
    }

    public List<ItemActivityInfoRespDto> getItemActivityInfo() {
        return itemActivityInfo;
    }

    public void setItemActivityInfo(List<ItemActivityInfoRespDto> itemActivityInfo) {
        this.itemActivityInfo = itemActivityInfo;
    }

    public List<ItemActivityInfoRespDto> getOrderActivityInfo() {
        return orderActivityInfo;
    }

    public void setOrderActivityInfo(List<ItemActivityInfoRespDto> orderActivityInfo) {
        this.orderActivityInfo = orderActivityInfo;
    }

    public List<ItemActivityInfoRespDto> getCouponActivityInfo() {
        return couponActivityInfo;
    }

    public void setCouponActivityInfo(List<ItemActivityInfoRespDto> couponActivityInfo) {
        this.couponActivityInfo = couponActivityInfo;
    }
}
