/**
 * @(#)MatchCouponRespDto.java 1.0 2019/11/27
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.response;

import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.common.CouponUseTimeDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 下单匹配可用优惠券详情
 *
 * @author wu.sheng
 * @date 2019/11/27 11:20
 */
@ApiModel(value = "MatchCouponRespDto", description = "下单匹配可用优惠券详情")
public class MatchCouponRespDto {

    @ApiModelProperty(name = "id",value = "优惠券id")
    private Long id;

    @ApiModelProperty(name = "couponTemplateId",value = "券模板id")
    private Long couponTemplateId;

    @ApiModelProperty(name = "activityId",value = "活动id")
    private Long activityId;

    @ApiModelProperty(name = "couponValue",value = "优惠券面值")
    private BigDecimal couponValue;

    @ApiModelProperty(name = "amount",value = "优惠券使用阈值")
    private BigDecimal amount;

    @ApiModelProperty(name = "userId",value = "归属人id")
    private Long userId;

    @ApiModelProperty(name = "couponName",value = "优惠券名称")
    private String couponName;

    @ApiModelProperty(name = "usableItemIds",value = "满足使用优惠券条件的商品id列表")
    private List<Long> usableItemIds;

    @ApiModelProperty(name = "status",value = "状态：1可用，0不可用")
    private Integer status;

    @ApiModelProperty(name = "effectiveTime",value = "生效时间")
    private Date effectiveTime;

    @ApiModelProperty(name = "invalidTime",value = "失效时间")
    private Date invalidTime;

    @ApiModelProperty(name = "couponRange", value = "券范围类型：10=平台券，20=店铺券")
    private Integer couponRange;

    @ApiModelProperty(name = "itemRange", value = "商品使用范围（SELLER：商户、SHOP：店铺、CATEGORY：类目、ITEM：商品）,全平台默认不传")
    private String itemRange;

    @ApiModelProperty(name = "unableReason", value = "不可用原因")
    private String unableReason;

    @ApiModelProperty(name = "sharedDiscountList", value = "共享优惠：1平台券与商家券同时使用，2与商家促销活动同时使用,多个[1,2]格式")
    private List<Integer> sharedDiscountList;

    @ApiModelProperty(name = "shopId", value = "前端分组显示使用，无实际意义")
    private Long shopId;

    @ApiModelProperty(name = "couponCategory",value = "券类别, 10=定额现金券（满减）, 50=满折券")
    private Integer couponCategory;

    @ApiModelProperty(name = "couponUseTimeDto",value = "用券时间类型定义")
    private CouponUseTimeDto couponUseTimeDto;

    @ApiModelProperty(name = "shopList", value = "该活动适用的店铺：店铺id列表")
    private List<Long> shopList;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getCouponTemplateId() {
        return couponTemplateId;
    }

    public void setCouponTemplateId(Long couponTemplateId) {
        this.couponTemplateId = couponTemplateId;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public BigDecimal getCouponValue() {
        return couponValue;
    }

    public void setCouponValue(BigDecimal couponValue) {
        this.couponValue = couponValue;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getCouponName() {
        return couponName;
    }

    public void setCouponName(String couponName) {
        this.couponName = couponName;
    }

    public List<Long> getUsableItemIds() {
        return usableItemIds;
    }

    public void setUsableItemIds(List<Long> usableItemIds) {
        this.usableItemIds = usableItemIds;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Date getEffectiveTime() {
        return effectiveTime;
    }

    public void setEffectiveTime(Date effectiveTime) {
        this.effectiveTime = effectiveTime;
    }

    public Date getInvalidTime() {
        return invalidTime;
    }

    public void setInvalidTime(Date invalidTime) {
        this.invalidTime = invalidTime;
    }

    public Integer getCouponRange() {
        return couponRange;
    }

    public void setCouponRange(Integer couponRange) {
        this.couponRange = couponRange;
    }

    public String getItemRange() {
        return itemRange;
    }

    public void setItemRange(String itemRange) {
        this.itemRange = itemRange;
    }

    public String getUnableReason() {
        return unableReason;
    }

    public void setUnableReason(String unableReason) {
        this.unableReason = unableReason;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public List<Integer> getSharedDiscountList() {
        return sharedDiscountList;
    }

    public void setSharedDiscountList(List<Integer> sharedDiscountList) {
        this.sharedDiscountList = sharedDiscountList;
    }

    public Integer getCouponCategory() {
        return couponCategory;
    }

    public void setCouponCategory(Integer couponCategory) {
        this.couponCategory = couponCategory;
    }

    public CouponUseTimeDto getCouponUseTimeDto() {
        return couponUseTimeDto;
    }

    public void setCouponUseTimeDto(CouponUseTimeDto couponUseTimeDto) {
        this.couponUseTimeDto = couponUseTimeDto;
    }

    public List<Long> getShopList() {
        return shopList;
    }

    public void setShopList(List<Long> shopList) {
        this.shopList = shopList;
    }
}
