package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.combination.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.List;

/**
 * @Description: 优惠套装商品dto
 * @Author yuangui
 * @Date 2021/11/25
 */
@ApiModel(value = "ComItemDto", description = "优惠套装商品dto")
public class ComItemDto {
    @ApiModelProperty(name = "skuId", value = "规格id")
    private Long skuId;

    @ApiModelProperty(name = "skuCode", value = "Sku编码")
    private String skuCode;

    @ApiModelProperty(name = "brandId",value = "品牌ID")
    private String brandId;

    @ApiModelProperty(name = "brand",value = "品牌名称")
    private String brand;

    @ApiModelProperty(name = "attr", value = "attr规格")
    private String attr;

    @ApiModelProperty(name = "dirId", value = "类目ID")
    private String dirId;

    @ApiModelProperty(name = "dirName", value = "类目名称")
    private String dirName;

    @ApiModelProperty(name = "itemId", value = "商品id")
    private Long itemId;

    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;

    @ApiModelProperty(name = "itemCode", value = "商品编码")
    private String itemCode;

    @ApiModelProperty(name = "shopName", value = "店铺名称")
    private String shopName;

    @ApiModelProperty(name = "totalStock", value = "可用库存")
    private Long totalStock;

    @ApiModelProperty(name = "combinationPrice", value = "套装单价")
    private BigDecimal combinationPrice;

    @ApiModelProperty(name = "combinationNum", value = "套装商品数量")
    private Long combinationNum;

    @ApiModelProperty(name = "batchs", value = "优惠套餐批次对象")
    private List<ComBatch> batchs;

    @ApiModelProperty(name = "cargoId", value = "货品ID")
    private Long cargoId;

    /**
     * 商品店铺id
     */
    @ApiModelProperty(name = "shopId", value = "商品店铺id")
    private Long shopId;

    @ApiModelProperty(name = "subType", value = "商品子类型")
    private Integer subType;

    public Long getCargoId() {
        return cargoId;
    }

    public void setCargoId(Long cargoId) {
        this.cargoId = cargoId;
    }

    public List<ComBatch> getBatchs() {
        return batchs;
    }

    public void setBatchs(List<ComBatch> batchs) {
        this.batchs = batchs;
    }

    public Integer getSubType() {
        return subType;
    }

    public void setSubType(Integer subType) {
        this.subType = subType;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getShopName() {
        return shopName;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }

    public Long getTotalStock() {
        return totalStock;
    }

    public void setTotalStock(Long totalStock) {
        this.totalStock = totalStock;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getBrandId() {
        return brandId;
    }

    public void setBrandId(String brandId) {
        this.brandId = brandId;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public String getAttr() {
        return attr;
    }

    public void setAttr(String attr) {
        this.attr = attr;
    }

    public String getDirId() {
        return dirId;
    }

    public void setDirId(String dirId) {
        this.dirId = dirId;
    }

    public String getDirName() {
        return dirName;
    }

    public void setDirName(String dirName) {
        this.dirName = dirName;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public BigDecimal getCombinationPrice() {
        return combinationPrice;
    }

    public void setCombinationPrice(BigDecimal combinationPrice) {
        this.combinationPrice = combinationPrice;
    }

    public Long getCombinationNum() {
        return combinationNum;
    }

    public void setCombinationNum(Long combinationNum) {
        this.combinationNum = combinationNum;
    }
}
