/**
 * @(#)ActivityGroupReqDto.java 1.0 2020/4/13
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.crowdordering.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 拼团队伍请求参数
 *
 * @author wu.sheng
 * @date 2020/4/13 15:59
 */
@ApiModel(value = "ActivityGroupAddReqDto", description = "拼团活动添加参数")
public class ActivityGroupAddReqDto {
    /**
     * 拼团活动ID
     */
    @ApiModelProperty(name = "activityId", value = "拼团活动ID")
    private Long activityId;
    /**
     * 团名称
     */
    @ApiModelProperty(name = "name", value = "团名称")
    private String name;
    /**
     * 开团人
     */
    @ApiModelProperty(name = "openGroupPerson", value = "开团人id")
    private Long openGroupPerson;
    /**
     * 开团时间
     */
    @ApiModelProperty(name = "openTime", value = "开团时间")
    private Date openTime;
    /**
     * 团结束时间
     */
    @ApiModelProperty(name = "closeTime", value = "团结束时间")
    private Date closeTime;
    @ApiModelProperty(name = "addMinutes", value = "团延长分钟")
    private int addMinutes;
    @ApiModelProperty(name = "joinNum", value = "参团人数限制")
    private Long joinNum;
    @ApiModelProperty(name = "joinAmount", value = "参团金额限制")
    private BigDecimal joinAmount;

    public int getAddMinutes() {
        return addMinutes;
    }

    public void setAddMinutes(int addMinutes) {
        this.addMinutes = addMinutes;
    }

    public Long getJoinNum() {
        return joinNum;
    }

    public void setJoinNum(Long joinNum) {
        this.joinNum = joinNum;
    }

    public BigDecimal getJoinAmount() {
        return joinAmount;
    }

    public void setJoinAmount(BigDecimal joinAmount) {
        this.joinAmount = joinAmount;
    }

    public Date getOpenTime() {
        return openTime;
    }

    public void setOpenTime(Date openTime) {
        this.openTime = openTime;
    }

    public Date getCloseTime() {
        return closeTime;
    }

    public void setCloseTime(Date closeTime) {
        this.closeTime = closeTime;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getOpenGroupPerson() {
        return openGroupPerson;
    }

    public void setOpenGroupPerson(Long openGroupPerson) {
        this.openGroupPerson = openGroupPerson;
    }

}
